@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin

import com.pulumi.alicloud.mongodb.ShardingInstanceArgs.builder
import com.pulumi.alicloud.mongodb.kotlin.inputs.ShardingInstanceConfigServerListArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.ShardingInstanceConfigServerListArgsBuilder
import com.pulumi.alicloud.mongodb.kotlin.inputs.ShardingInstanceMongoListArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.ShardingInstanceMongoListArgsBuilder
import com.pulumi.alicloud.mongodb.kotlin.inputs.ShardingInstanceShardListArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.ShardingInstanceShardListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a MongoDB Sharding Instance resource supports replica set instances only. the MongoDB provides stable, reliable, and automatic scalable database services.
 * It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/doc-detail/26558.htm)
 * > **NOTE:** Available since v1.40.0.
 * > **NOTE:**  The following regions don't support create Classic network MongoDB Sharding Instance.
 * [`cn-zhangjiakou`,`cn-huhehaote`,`ap-southeast-3`,`ap-southeast-5`,`me-east-1`,`ap-northeast-1`,`eu-west-1`]
 * > **NOTE:**  Create MongoDB Sharding instance or change instance type and storage would cost 10~20 minutes. Please make full preparation.
 * ## Example Usage
 * ### Create a Mongodb Sharding instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.mongodb.getZones({});
 * const index = _default.then(_default => _default.zones).length.then(length => length - 1);
 * const zoneId = _default.then(_default => _default.zones[index].id);
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: zoneId,
 * });
 * const defaultShardingInstance = new alicloud.mongodb.ShardingInstance("default", {
 *     engineVersion: "4.2",
 *     vswitchId: defaultSwitch.id,
 *     zoneId: zoneId,
 *     name: name,
 *     mongoLists: [
 *         {
 *             nodeClass: "dds.mongos.mid",
 *         },
 *         {
 *             nodeClass: "dds.mongos.mid",
 *         },
 *     ],
 *     shardLists: [
 *         {
 *             nodeClass: "dds.shard.mid",
 *             nodeStorage: 10,
 *         },
 *         {
 *             nodeClass: "dds.shard.standard",
 *             nodeStorage: 20,
 *             readonlyReplicas: 1,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.mongodb.get_zones()
 * index = len(default.zones) - 1
 * zone_id = default.zones[index].id
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=zone_id)
 * default_sharding_instance = alicloud.mongodb.ShardingInstance("default",
 *     engine_version="4.2",
 *     vswitch_id=default_switch.id,
 *     zone_id=zone_id,
 *     name=name,
 *     mongo_lists=[
 *         {
 *             "node_class": "dds.mongos.mid",
 *         },
 *         {
 *             "node_class": "dds.mongos.mid",
 *         },
 *     ],
 *     shard_lists=[
 *         {
 *             "node_class": "dds.shard.mid",
 *             "node_storage": 10,
 *         },
 *         {
 *             "node_class": "dds.shard.standard",
 *             "node_storage": 20,
 *             "readonly_replicas": 1,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.MongoDB.GetZones.Invoke();
 *     var index = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)).Length.Apply(length => length - 1);
 *     var zoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)[index].Id);
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = zoneId,
 *     });
 *     var defaultShardingInstance = new AliCloud.MongoDB.ShardingInstance("default", new()
 *     {
 *         EngineVersion = "4.2",
 *         VswitchId = defaultSwitch.Id,
 *         ZoneId = zoneId,
 *         Name = name,
 *         MongoLists = new[]
 *         {
 *             new AliCloud.MongoDB.Inputs.ShardingInstanceMongoListArgs
 *             {
 *                 NodeClass = "dds.mongos.mid",
 *             },
 *             new AliCloud.MongoDB.Inputs.ShardingInstanceMongoListArgs
 *             {
 *                 NodeClass = "dds.mongos.mid",
 *             },
 *         },
 *         ShardLists = new[]
 *         {
 *             new AliCloud.MongoDB.Inputs.ShardingInstanceShardListArgs
 *             {
 *                 NodeClass = "dds.shard.mid",
 *                 NodeStorage = 10,
 *             },
 *             new AliCloud.MongoDB.Inputs.ShardingInstanceShardListArgs
 *             {
 *                 NodeClass = "dds.shard.standard",
 *                 NodeStorage = 20,
 *                 ReadonlyReplicas = 1,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := mongodb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		index := pulumi.Float64(len(_default.Zones)) - 1
 * 		zoneId := _default.Zones[index].Id
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(zoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mongodb.NewShardingInstance(ctx, "default", &mongodb.ShardingInstanceArgs{
 * 			EngineVersion: pulumi.String("4.2"),
 * 			VswitchId:     defaultSwitch.ID(),
 * 			ZoneId:        pulumi.String(zoneId),
 * 			Name:          pulumi.String(name),
 * 			MongoLists: mongodb.ShardingInstanceMongoListArray{
 * 				&mongodb.ShardingInstanceMongoListArgs{
 * 					NodeClass: pulumi.String("dds.mongos.mid"),
 * 				},
 * 				&mongodb.ShardingInstanceMongoListArgs{
 * 					NodeClass: pulumi.String("dds.mongos.mid"),
 * 				},
 * 			},
 * 			ShardLists: mongodb.ShardingInstanceShardListArray{
 * 				&mongodb.ShardingInstanceShardListArgs{
 * 					NodeClass:   pulumi.String("dds.shard.mid"),
 * 					NodeStorage: pulumi.Int(10),
 * 				},
 * 				&mongodb.ShardingInstanceShardListArgs{
 * 					NodeClass:        pulumi.String("dds.shard.standard"),
 * 					NodeStorage:      pulumi.Int(20),
 * 					ReadonlyReplicas: pulumi.Int(1),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mongodb.MongodbFunctions;
 * import com.pulumi.alicloud.mongodb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.mongodb.ShardingInstance;
 * import com.pulumi.alicloud.mongodb.ShardingInstanceArgs;
 * import com.pulumi.alicloud.mongodb.inputs.ShardingInstanceMongoListArgs;
 * import com.pulumi.alicloud.mongodb.inputs.ShardingInstanceShardListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = MongodbFunctions.getZones();
 *         final var index = default_.zones().length() - 1;
 *         final var zoneId = default_.zones()[index].id();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(zoneId)
 *             .build());
 *         var defaultShardingInstance = new ShardingInstance("defaultShardingInstance", ShardingInstanceArgs.builder()
 *             .engineVersion("4.2")
 *             .vswitchId(defaultSwitch.id())
 *             .zoneId(zoneId)
 *             .name(name)
 *             .mongoLists(
 *                 ShardingInstanceMongoListArgs.builder()
 *                     .nodeClass("dds.mongos.mid")
 *                     .build(),
 *                 ShardingInstanceMongoListArgs.builder()
 *                     .nodeClass("dds.mongos.mid")
 *                     .build())
 *             .shardLists(
 *                 ShardingInstanceShardListArgs.builder()
 *                     .nodeClass("dds.shard.mid")
 *                     .nodeStorage("10")
 *                     .build(),
 *                 ShardingInstanceShardListArgs.builder()
 *                     .nodeClass("dds.shard.standard")
 *                     .nodeStorage("20")
 *                     .readonlyReplicas("1")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use to the existing mongodb-sharding module
 * to create a MongoDB Sharding Instance resource one-click.
 * ## Import
 * MongoDB Sharding Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mongodb/shardingInstance:ShardingInstance example dds-bp1291daeda44195
 * ```
 * @property accountPassword Password of the root account. It is a string of 6 to 32 characters and is composed of letters, numbers, and underlines.
 * @property autoRenew Auto renew for prepaid. Default value: `false`. Valid values: `true`, `false`.
 * @property backupPeriods MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]
 * @property backupTime Sharding Instance backup time. It is required when `backup_period` was existed. In the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. If not set, the system will return a default, like "23:00Z-24:00Z".
 * @property configServerLists The ConfigServer nodes of the instance. See `config_server_list` below.
 * @property engineVersion Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/en/doc-detail/61884.htm) `EngineVersion`. **NOTE:** From version 1.225.1, `engine_version` can be modified.
 * @property instanceChargeType The billing method of the instance. Default value: `PostPaid`. Valid values: `PrePaid`, `PostPaid`. **NOTE:** It can be modified from `PostPaid` to `PrePaid` after version v1.141.0.
 * @property kmsEncryptedPassword An KMS encrypts password used to a instance. If the `account_password` is filled in, this field will be ignored.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
 * @property mongoLists The Mongo nodes of the instance. The mongo-node count can be purchased is in range of [2, 32]. See `mongo_list` below.
 * @property name The name of DB instance. It must be 2 to 256 characters in length.
 * @property networkType The network type of the instance. Valid values:`Classic` or `VPC`.
 * @property orderType The type of configuration changes performed. Default value: `DOWNGRADE`. Valid values:
 * - `UPGRADE`: The specifications are upgraded.
 * - `DOWNGRADE`: The specifications are downgraded.
 * **NOTE:** `order_type` is only applicable to instances when `instance_charge_type` is `PrePaid`.
 * @property period The duration that you will buy DB instance (in month). It is valid when `instance_charge_type` is `PrePaid`. Default value: `1`. Valid values: [1~9], 12, 24, 36.
 * @property protocolType The type of the access protocol. Valid values: `mongodb` or `dynamodb`.
 * @property provisionedIops The provisioned IOPS. Valid values: `0` to `50000`.
 * @property resourceGroupId The ID of the Resource Group.
 * @property securityGroupId The Security Group ID of ECS.
 * @property securityIpLists List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32])&#46; System default to `["127&#46;0&#46;0&#46;1"]`.
 * @property shardLists The Shard nodes of the instance. The shard-node count can be purchased is in range of [2, 32]. See `shard_list` below.
 * @property storageEngine The storage engine of the instance. Default value: `WiredTiger`. Valid values: `WiredTiger`, `RocksDB`.
 * @property storageType The storage type of the instance. Valid values: `cloud_essd1`, `cloud_essd2`, `cloud_essd3`, `cloud_auto`, `local_ssd`. **NOTE:** From version 1.229.0, `storage_type` can be modified. However, `storage_type` can only be modified to `cloud_auto`.
 * @property tags A mapping of tags to assign to the resource.
 * @property tdeStatus The TDE(Transparent Data Encryption) status. It can be updated from version 1.160.0.
 * @property vpcId The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
 * @property vswitchId The virtual switch ID to launch DB instances in one VPC.
 * @property zoneId The Zone to launch the DB instance. MongoDB Sharding Instance does not support multiple-zone.
 * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in one of them.
 */
public data class ShardingInstanceArgs(
    public val accountPassword: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val backupPeriods: Output<List<String>>? = null,
    public val backupTime: Output<String>? = null,
    public val configServerLists: Output<List<ShardingInstanceConfigServerListArgs>>? = null,
    public val engineVersion: Output<String>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    public val mongoLists: Output<List<ShardingInstanceMongoListArgs>>? = null,
    public val name: Output<String>? = null,
    public val networkType: Output<String>? = null,
    public val orderType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val protocolType: Output<String>? = null,
    public val provisionedIops: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val securityIpLists: Output<List<String>>? = null,
    public val shardLists: Output<List<ShardingInstanceShardListArgs>>? = null,
    public val storageEngine: Output<String>? = null,
    public val storageType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tdeStatus: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.ShardingInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.ShardingInstanceArgs =
        com.pulumi.alicloud.mongodb.ShardingInstanceArgs.builder()
            .accountPassword(accountPassword?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .backupPeriods(backupPeriods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .backupTime(backupTime?.applyValue({ args0 -> args0 }))
            .configServerLists(
                configServerLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .mongoLists(
                mongoLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .orderType(orderType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .protocolType(protocolType?.applyValue({ args0 -> args0 }))
            .provisionedIops(provisionedIops?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .securityIpLists(securityIpLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .shardLists(
                shardLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageEngine(storageEngine?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tdeStatus(tdeStatus?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ShardingInstanceArgs].
 */
@PulumiTagMarker
public class ShardingInstanceArgsBuilder internal constructor() {
    private var accountPassword: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var backupPeriods: Output<List<String>>? = null

    private var backupTime: Output<String>? = null

    private var configServerLists: Output<List<ShardingInstanceConfigServerListArgs>>? = null

    private var engineVersion: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var mongoLists: Output<List<ShardingInstanceMongoListArgs>>? = null

    private var name: Output<String>? = null

    private var networkType: Output<String>? = null

    private var orderType: Output<String>? = null

    private var period: Output<Int>? = null

    private var protocolType: Output<String>? = null

    private var provisionedIops: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var securityIpLists: Output<List<String>>? = null

    private var shardLists: Output<List<ShardingInstanceShardListArgs>>? = null

    private var storageEngine: Output<String>? = null

    private var storageType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tdeStatus: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Password of the root account. It is a string of 6 to 32 characters and is composed of letters, numbers, and underlines.
     */
    @JvmName("mxtbyafapqanqqly")
    public suspend fun accountPassword(`value`: Output<String>) {
        this.accountPassword = value
    }

    /**
     * @param value Auto renew for prepaid. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("rbhwahsadlbynfiy")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]
     */
    @JvmName("nfocfnithnpbauke")
    public suspend fun backupPeriods(`value`: Output<List<String>>) {
        this.backupPeriods = value
    }

    @JvmName("yqqjxcbiglhuwatl")
    public suspend fun backupPeriods(vararg values: Output<String>) {
        this.backupPeriods = Output.all(values.asList())
    }

    /**
     * @param values MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]
     */
    @JvmName("gioahlveiwsyarrb")
    public suspend fun backupPeriods(values: List<Output<String>>) {
        this.backupPeriods = Output.all(values)
    }

    /**
     * @param value Sharding Instance backup time. It is required when `backup_period` was existed. In the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. If not set, the system will return a default, like "23:00Z-24:00Z".
     */
    @JvmName("uhskbufyfbxlkxis")
    public suspend fun backupTime(`value`: Output<String>) {
        this.backupTime = value
    }

    /**
     * @param value The ConfigServer nodes of the instance. See `config_server_list` below.
     */
    @JvmName("iymckcpdsdrapjtq")
    public suspend fun configServerLists(`value`: Output<List<ShardingInstanceConfigServerListArgs>>) {
        this.configServerLists = value
    }

    @JvmName("apohpwvdjnvtxqxf")
    public suspend fun configServerLists(vararg values: Output<ShardingInstanceConfigServerListArgs>) {
        this.configServerLists = Output.all(values.asList())
    }

    /**
     * @param values The ConfigServer nodes of the instance. See `config_server_list` below.
     */
    @JvmName("vvuybevpbnrprsxh")
    public suspend fun configServerLists(values: List<Output<ShardingInstanceConfigServerListArgs>>) {
        this.configServerLists = Output.all(values)
    }

    /**
     * @param value Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/en/doc-detail/61884.htm) `EngineVersion`. **NOTE:** From version 1.225.1, `engine_version` can be modified.
     */
    @JvmName("fnhntdjjchmelnvj")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The billing method of the instance. Default value: `PostPaid`. Valid values: `PrePaid`, `PostPaid`. **NOTE:** It can be modified from `PostPaid` to `PrePaid` after version v1.141.0.
     */
    @JvmName("mvgwrepvxpbqfjbt")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value An KMS encrypts password used to a instance. If the `account_password` is filled in, this field will be ignored.
     */
    @JvmName("vapofpanqfchamcw")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("oavgvfngbalydatu")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value The Mongo nodes of the instance. The mongo-node count can be purchased is in range of [2, 32]. See `mongo_list` below.
     */
    @JvmName("ldpaldosugdfdixv")
    public suspend fun mongoLists(`value`: Output<List<ShardingInstanceMongoListArgs>>) {
        this.mongoLists = value
    }

    @JvmName("jltcneptvkpmlpiq")
    public suspend fun mongoLists(vararg values: Output<ShardingInstanceMongoListArgs>) {
        this.mongoLists = Output.all(values.asList())
    }

    /**
     * @param values The Mongo nodes of the instance. The mongo-node count can be purchased is in range of [2, 32]. See `mongo_list` below.
     */
    @JvmName("pkctbwbdgncshgwy")
    public suspend fun mongoLists(values: List<Output<ShardingInstanceMongoListArgs>>) {
        this.mongoLists = Output.all(values)
    }

    /**
     * @param value The name of DB instance. It must be 2 to 256 characters in length.
     */
    @JvmName("rndsisknrfbmgqrp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The network type of the instance. Valid values:`Classic` or `VPC`.
     */
    @JvmName("jfncfododfvvexfn")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value The type of configuration changes performed. Default value: `DOWNGRADE`. Valid values:
     * - `UPGRADE`: The specifications are upgraded.
     * - `DOWNGRADE`: The specifications are downgraded.
     * **NOTE:** `order_type` is only applicable to instances when `instance_charge_type` is `PrePaid`.
     */
    @JvmName("seqvuttifqktrufs")
    public suspend fun orderType(`value`: Output<String>) {
        this.orderType = value
    }

    /**
     * @param value The duration that you will buy DB instance (in month). It is valid when `instance_charge_type` is `PrePaid`. Default value: `1`. Valid values: [1~9], 12, 24, 36.
     */
    @JvmName("hwekefwbyhpkdkca")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The type of the access protocol. Valid values: `mongodb` or `dynamodb`.
     */
    @JvmName("ammstvsghornmtnb")
    public suspend fun protocolType(`value`: Output<String>) {
        this.protocolType = value
    }

    /**
     * @param value The provisioned IOPS. Valid values: `0` to `50000`.
     */
    @JvmName("yvgoqmcbwqqkrihk")
    public suspend fun provisionedIops(`value`: Output<Int>) {
        this.provisionedIops = value
    }

    /**
     * @param value The ID of the Resource Group.
     */
    @JvmName("rtwknajwulcvcuwr")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The Security Group ID of ECS.
     */
    @JvmName("htyepkowbmsijdvm")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32])&#46; System default to `["127&#46;0&#46;0&#46;1"]`.
     */
    @JvmName("wmsuuvwnlucxvfwf")
    public suspend fun securityIpLists(`value`: Output<List<String>>) {
        this.securityIpLists = value
    }

    @JvmName("mnxsgkwagtkkdhko")
    public suspend fun securityIpLists(vararg values: Output<String>) {
        this.securityIpLists = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32])&#46; System default to `["127&#46;0&#46;0&#46;1"]`.
     */
    @JvmName("sjclyutcetfvubug")
    public suspend fun securityIpLists(values: List<Output<String>>) {
        this.securityIpLists = Output.all(values)
    }

    /**
     * @param value The Shard nodes of the instance. The shard-node count can be purchased is in range of [2, 32]. See `shard_list` below.
     */
    @JvmName("hxrudawnwsesgfhn")
    public suspend fun shardLists(`value`: Output<List<ShardingInstanceShardListArgs>>) {
        this.shardLists = value
    }

    @JvmName("ntqmqevtoboypdpe")
    public suspend fun shardLists(vararg values: Output<ShardingInstanceShardListArgs>) {
        this.shardLists = Output.all(values.asList())
    }

    /**
     * @param values The Shard nodes of the instance. The shard-node count can be purchased is in range of [2, 32]. See `shard_list` below.
     */
    @JvmName("ogujnwxwwtsghtxq")
    public suspend fun shardLists(values: List<Output<ShardingInstanceShardListArgs>>) {
        this.shardLists = Output.all(values)
    }

    /**
     * @param value The storage engine of the instance. Default value: `WiredTiger`. Valid values: `WiredTiger`, `RocksDB`.
     */
    @JvmName("wiltdqjoyjjjgctv")
    public suspend fun storageEngine(`value`: Output<String>) {
        this.storageEngine = value
    }

    /**
     * @param value The storage type of the instance. Valid values: `cloud_essd1`, `cloud_essd2`, `cloud_essd3`, `cloud_auto`, `local_ssd`. **NOTE:** From version 1.229.0, `storage_type` can be modified. However, `storage_type` can only be modified to `cloud_auto`.
     */
    @JvmName("hqfspdssdnudknha")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ikxvhloxewdnwiid")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The TDE(Transparent Data Encryption) status. It can be updated from version 1.160.0.
     */
    @JvmName("fyboburarbctlxoi")
    public suspend fun tdeStatus(`value`: Output<String>) {
        this.tdeStatus = value
    }

    /**
     * @param value The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
     */
    @JvmName("pjwijaragijqxmef")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC.
     */
    @JvmName("hrusvotabbadawbs")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Zone to launch the DB instance. MongoDB Sharding Instance does not support multiple-zone.
     * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in one of them.
     */
    @JvmName("agnuymfccmdxhifc")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Password of the root account. It is a string of 6 to 32 characters and is composed of letters, numbers, and underlines.
     */
    @JvmName("xvsxlphrhfvhidqu")
    public suspend fun accountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountPassword = mapped
    }

    /**
     * @param value Auto renew for prepaid. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("srmdrmbwqmkjunaf")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]
     */
    @JvmName("ickrtsyrchxaojkk")
    public suspend fun backupPeriods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPeriods = mapped
    }

    /**
     * @param values MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]
     */
    @JvmName("qnbemoyhsjeaivwh")
    public suspend fun backupPeriods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupPeriods = mapped
    }

    /**
     * @param value Sharding Instance backup time. It is required when `backup_period` was existed. In the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. If not set, the system will return a default, like "23:00Z-24:00Z".
     */
    @JvmName("caasgxgfjnortnrd")
    public suspend fun backupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupTime = mapped
    }

    /**
     * @param value The ConfigServer nodes of the instance. See `config_server_list` below.
     */
    @JvmName("wgffsxdtlryxblow")
    public suspend fun configServerLists(`value`: List<ShardingInstanceConfigServerListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configServerLists = mapped
    }

    /**
     * @param argument The ConfigServer nodes of the instance. See `config_server_list` below.
     */
    @JvmName("xqsudipswcxwtgpx")
    public suspend fun configServerLists(argument: List<suspend ShardingInstanceConfigServerListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ShardingInstanceConfigServerListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configServerLists = mapped
    }

    /**
     * @param argument The ConfigServer nodes of the instance. See `config_server_list` below.
     */
    @JvmName("kyexhnllwuxqfysl")
    public suspend fun configServerLists(vararg argument: suspend ShardingInstanceConfigServerListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ShardingInstanceConfigServerListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configServerLists = mapped
    }

    /**
     * @param argument The ConfigServer nodes of the instance. See `config_server_list` below.
     */
    @JvmName("oaqyedeaftcdvhkf")
    public suspend fun configServerLists(argument: suspend ShardingInstanceConfigServerListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ShardingInstanceConfigServerListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configServerLists = mapped
    }

    /**
     * @param values The ConfigServer nodes of the instance. See `config_server_list` below.
     */
    @JvmName("gkiwvlrbofufepsd")
    public suspend fun configServerLists(vararg values: ShardingInstanceConfigServerListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configServerLists = mapped
    }

    /**
     * @param value Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/en/doc-detail/61884.htm) `EngineVersion`. **NOTE:** From version 1.225.1, `engine_version` can be modified.
     */
    @JvmName("gvwojqnuawlndrxt")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The billing method of the instance. Default value: `PostPaid`. Valid values: `PrePaid`, `PostPaid`. **NOTE:** It can be modified from `PostPaid` to `PrePaid` after version v1.141.0.
     */
    @JvmName("pypllsqmkyerepna")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value An KMS encrypts password used to a instance. If the `account_password` is filled in, this field will be ignored.
     */
    @JvmName("ubupnyqavndrpgdj")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("ydnetvbokxqwdcoa")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("tvffoovxngeuchnb")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value The Mongo nodes of the instance. The mongo-node count can be purchased is in range of [2, 32]. See `mongo_list` below.
     */
    @JvmName("evlhajipwbhehnoq")
    public suspend fun mongoLists(`value`: List<ShardingInstanceMongoListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mongoLists = mapped
    }

    /**
     * @param argument The Mongo nodes of the instance. The mongo-node count can be purchased is in range of [2, 32]. See `mongo_list` below.
     */
    @JvmName("hbkaepsyukjevnwe")
    public suspend fun mongoLists(argument: List<suspend ShardingInstanceMongoListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ShardingInstanceMongoListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mongoLists = mapped
    }

    /**
     * @param argument The Mongo nodes of the instance. The mongo-node count can be purchased is in range of [2, 32]. See `mongo_list` below.
     */
    @JvmName("xdjqbrofaplxvbgo")
    public suspend fun mongoLists(vararg argument: suspend ShardingInstanceMongoListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ShardingInstanceMongoListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mongoLists = mapped
    }

    /**
     * @param argument The Mongo nodes of the instance. The mongo-node count can be purchased is in range of [2, 32]. See `mongo_list` below.
     */
    @JvmName("hjtsumgjnlhfostk")
    public suspend fun mongoLists(argument: suspend ShardingInstanceMongoListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ShardingInstanceMongoListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.mongoLists = mapped
    }

    /**
     * @param values The Mongo nodes of the instance. The mongo-node count can be purchased is in range of [2, 32]. See `mongo_list` below.
     */
    @JvmName("jfqgfymihursspfn")
    public suspend fun mongoLists(vararg values: ShardingInstanceMongoListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mongoLists = mapped
    }

    /**
     * @param value The name of DB instance. It must be 2 to 256 characters in length.
     */
    @JvmName("cqxgaodrdidbmbtx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The network type of the instance. Valid values:`Classic` or `VPC`.
     */
    @JvmName("uaeaubqjsxwwywtb")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value The type of configuration changes performed. Default value: `DOWNGRADE`. Valid values:
     * - `UPGRADE`: The specifications are upgraded.
     * - `DOWNGRADE`: The specifications are downgraded.
     * **NOTE:** `order_type` is only applicable to instances when `instance_charge_type` is `PrePaid`.
     */
    @JvmName("uhjnlmhyqswubuwp")
    public suspend fun orderType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderType = mapped
    }

    /**
     * @param value The duration that you will buy DB instance (in month). It is valid when `instance_charge_type` is `PrePaid`. Default value: `1`. Valid values: [1~9], 12, 24, 36.
     */
    @JvmName("acjpvddfnhuvjukw")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The type of the access protocol. Valid values: `mongodb` or `dynamodb`.
     */
    @JvmName("admuxrrrhnasuwhj")
    public suspend fun protocolType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value The provisioned IOPS. Valid values: `0` to `50000`.
     */
    @JvmName("mnboyoopotggangs")
    public suspend fun provisionedIops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedIops = mapped
    }

    /**
     * @param value The ID of the Resource Group.
     */
    @JvmName("opvghltwymcfebxr")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The Security Group ID of ECS.
     */
    @JvmName("vfsjhkshugsgdyte")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32])&#46; System default to `["127&#46;0&#46;0&#46;1"]`.
     */
    @JvmName("swvtxywjpuwivyrd")
    public suspend fun securityIpLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpLists = mapped
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32])&#46; System default to `["127&#46;0&#46;0&#46;1"]`.
     */
    @JvmName("oosjwqosejmhppxg")
    public suspend fun securityIpLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIpLists = mapped
    }

    /**
     * @param value The Shard nodes of the instance. The shard-node count can be purchased is in range of [2, 32]. See `shard_list` below.
     */
    @JvmName("bbpyrlnsrdqldxls")
    public suspend fun shardLists(`value`: List<ShardingInstanceShardListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardLists = mapped
    }

    /**
     * @param argument The Shard nodes of the instance. The shard-node count can be purchased is in range of [2, 32]. See `shard_list` below.
     */
    @JvmName("sacadhjrdkadephx")
    public suspend fun shardLists(argument: List<suspend ShardingInstanceShardListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ShardingInstanceShardListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.shardLists = mapped
    }

    /**
     * @param argument The Shard nodes of the instance. The shard-node count can be purchased is in range of [2, 32]. See `shard_list` below.
     */
    @JvmName("esxaicmdtjnlclhk")
    public suspend fun shardLists(vararg argument: suspend ShardingInstanceShardListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ShardingInstanceShardListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.shardLists = mapped
    }

    /**
     * @param argument The Shard nodes of the instance. The shard-node count can be purchased is in range of [2, 32]. See `shard_list` below.
     */
    @JvmName("cjiwjuukmmygjyvv")
    public suspend fun shardLists(argument: suspend ShardingInstanceShardListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ShardingInstanceShardListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.shardLists = mapped
    }

    /**
     * @param values The Shard nodes of the instance. The shard-node count can be purchased is in range of [2, 32]. See `shard_list` below.
     */
    @JvmName("elbtswktsedfwedq")
    public suspend fun shardLists(vararg values: ShardingInstanceShardListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shardLists = mapped
    }

    /**
     * @param value The storage engine of the instance. Default value: `WiredTiger`. Valid values: `WiredTiger`, `RocksDB`.
     */
    @JvmName("kanfxfwchurdjjxd")
    public suspend fun storageEngine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEngine = mapped
    }

    /**
     * @param value The storage type of the instance. Valid values: `cloud_essd1`, `cloud_essd2`, `cloud_essd3`, `cloud_auto`, `local_ssd`. **NOTE:** From version 1.229.0, `storage_type` can be modified. However, `storage_type` can only be modified to `cloud_auto`.
     */
    @JvmName("tcwyjqnewufejpdd")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ywbeuequednqnrpl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("ixkktyehmaatgyjb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The TDE(Transparent Data Encryption) status. It can be updated from version 1.160.0.
     */
    @JvmName("ykklahukuxppgdnu")
    public suspend fun tdeStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tdeStatus = mapped
    }

    /**
     * @param value The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
     */
    @JvmName("bhmmcvoqjddvsqvp")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC.
     */
    @JvmName("fykhubcjryoiuprb")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Zone to launch the DB instance. MongoDB Sharding Instance does not support multiple-zone.
     * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in one of them.
     */
    @JvmName("pwjgjyeckbogilvd")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ShardingInstanceArgs = ShardingInstanceArgs(
        accountPassword = accountPassword,
        autoRenew = autoRenew,
        backupPeriods = backupPeriods,
        backupTime = backupTime,
        configServerLists = configServerLists,
        engineVersion = engineVersion,
        instanceChargeType = instanceChargeType,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        mongoLists = mongoLists,
        name = name,
        networkType = networkType,
        orderType = orderType,
        period = period,
        protocolType = protocolType,
        provisionedIops = provisionedIops,
        resourceGroupId = resourceGroupId,
        securityGroupId = securityGroupId,
        securityIpLists = securityIpLists,
        shardLists = shardLists,
        storageEngine = storageEngine,
        storageType = storageType,
        tags = tags,
        tdeStatus = tdeStatus,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
