@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.inputs

import com.pulumi.alicloud.mongodb.inputs.GetAccountsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccounts.
 * @property accountName The name of the account. Valid values: `root`.
 * @property instanceId The ID of the instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetAccountsPlainArgs(
    public val accountName: String? = null,
    public val instanceId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.inputs.GetAccountsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.inputs.GetAccountsPlainArgs =
        com.pulumi.alicloud.mongodb.inputs.GetAccountsPlainArgs.builder()
            .accountName(accountName?.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountsPlainArgs].
 */
@PulumiTagMarker
public class GetAccountsPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    /**
     * @param value The name of the account. Valid values: `root`.
     */
    @JvmName("yoxbqstbrdqooxdt")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("elvvyqsfowfsgfgc")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hnndnfputroffqkv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAccountsPlainArgs = GetAccountsPlainArgs(
        accountName = accountName,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
    )
}
