@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.inputs

import com.pulumi.alicloud.mongodb.inputs.GetAuditPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAuditPolicies.
 * @property dbInstanceId The id of the db instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetAuditPoliciesPlainArgs(
    public val dbInstanceId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.inputs.GetAuditPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.inputs.GetAuditPoliciesPlainArgs =
        com.pulumi.alicloud.mongodb.inputs.GetAuditPoliciesPlainArgs.builder()
            .dbInstanceId(dbInstanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAuditPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetAuditPoliciesPlainArgsBuilder internal constructor() {
    private var dbInstanceId: String? = null

    private var outputFile: String? = null

    /**
     * @param value The id of the db instance.
     */
    @JvmName("dhvgjuppcmjdqilw")
    public suspend fun dbInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbInstanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wpafwfksubelsqca")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAuditPoliciesPlainArgs = GetAuditPoliciesPlainArgs(
        dbInstanceId = dbInstanceId ?: throw PulumiNullFieldException("dbInstanceId"),
        outputFile = outputFile,
    )
}
