@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.inputs

import com.pulumi.alicloud.mongodb.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property availabilityZone Instance availability zone.
 * @property ids The ids list of MongoDB instances
 * @property instanceClass Sizing of the instance to be queried.
 * @property instanceType Type of the instance to be queried. If it is set to `sharding`, the sharded cluster instances are listed. If it is set to `replicate`, replica set instances are listed. Default value `replicate`.
 * @property nameRegex A regex string to apply to the instance name.
 * @property outputFile The name of file that can save the collection of instances after running `pulumi preview`.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetInstancesPlainArgs(
    public val availabilityZone: String? = null,
    public val ids: List<String>? = null,
    public val instanceClass: String? = null,
    public val instanceType: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.mongodb.inputs.GetInstancesPlainArgs.builder()
            .availabilityZone(availabilityZone?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceClass(instanceClass?.let({ args0 -> args0 }))
            .instanceType(instanceType?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var availabilityZone: String? = null

    private var ids: List<String>? = null

    private var instanceClass: String? = null

    private var instanceType: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Instance availability zone.
     */
    @JvmName("afqptgfyjdgrbfhr")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZone = mapped
    }

    /**
     * @param value The ids list of MongoDB instances
     */
    @JvmName("phbuiuynnivhkdhk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values The ids list of MongoDB instances
     */
    @JvmName("nlwkpkumcsrrkrwb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Sizing of the instance to be queried.
     */
    @JvmName("vlhxicbjuhamgmkw")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceClass = mapped
    }

    /**
     * @param value Type of the instance to be queried. If it is set to `sharding`, the sharded cluster instances are listed. If it is set to `replicate`, replica set instances are listed. Default value `replicate`.
     */
    @JvmName("vsvovhgexjntrbty")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value A regex string to apply to the instance name.
     */
    @JvmName("bqmbhjpnpntvmxwb")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The name of file that can save the collection of instances after running `pulumi preview`.
     */
    @JvmName("nowrquwoxgxdkurc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ewslnajmqxfhvxbc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("hobxlnpjpogsoqnk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        availabilityZone = availabilityZone,
        ids = ids,
        instanceClass = instanceClass,
        instanceType = instanceType,
        nameRegex = nameRegex,
        outputFile = outputFile,
        tags = tags,
    )
}
