@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.inputs

import com.pulumi.alicloud.mongodb.inputs.GetShardingNetworkPrivateAddressesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getShardingNetworkPrivateAddresses.
 * @property dbInstanceId The db instance id.
 * @property nodeId The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property role The role of the node. Valid values: `Primary` or `Secondary`.
 */
public data class GetShardingNetworkPrivateAddressesPlainArgs(
    public val dbInstanceId: String,
    public val nodeId: String? = null,
    public val outputFile: String? = null,
    public val role: String? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.mongodb.inputs.GetShardingNetworkPrivateAddressesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.inputs.GetShardingNetworkPrivateAddressesPlainArgs =
        com.pulumi.alicloud.mongodb.inputs.GetShardingNetworkPrivateAddressesPlainArgs.builder()
            .dbInstanceId(dbInstanceId.let({ args0 -> args0 }))
            .nodeId(nodeId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .role(role?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetShardingNetworkPrivateAddressesPlainArgs].
 */
@PulumiTagMarker
public class GetShardingNetworkPrivateAddressesPlainArgsBuilder internal constructor() {
    private var dbInstanceId: String? = null

    private var nodeId: String? = null

    private var outputFile: String? = null

    private var role: String? = null

    /**
     * @param value The db instance id.
     */
    @JvmName("gamqvpsdcatdbwgu")
    public suspend fun dbInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbInstanceId = mapped
    }

    /**
     * @param value The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
     */
    @JvmName("atrmlmtpsoufabym")
    public suspend fun nodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nodeId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rcmqcvrrfixploqx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The role of the node. Valid values: `Primary` or `Secondary`.
     */
    @JvmName("lwuhfwayothtluni")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.role = mapped
    }

    internal fun build(): GetShardingNetworkPrivateAddressesPlainArgs =
        GetShardingNetworkPrivateAddressesPlainArgs(
            dbInstanceId = dbInstanceId ?: throw PulumiNullFieldException("dbInstanceId"),
            nodeId = nodeId,
            outputFile = outputFile,
            role = role,
        )
}
