@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.inputs

import com.pulumi.alicloud.mongodb.inputs.GetShardingNetworkPublicAddressesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getShardingNetworkPublicAddresses.
 * @property dbInstanceId The db instance id.
 * @property nodeId The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property role The role of the node. Valid values: `Primary` or `Secondary`.
 */
public data class GetShardingNetworkPublicAddressesPlainArgs(
    public val dbInstanceId: String,
    public val nodeId: String? = null,
    public val outputFile: String? = null,
    public val role: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.inputs.GetShardingNetworkPublicAddressesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.inputs.GetShardingNetworkPublicAddressesPlainArgs =
        com.pulumi.alicloud.mongodb.inputs.GetShardingNetworkPublicAddressesPlainArgs.builder()
            .dbInstanceId(dbInstanceId.let({ args0 -> args0 }))
            .nodeId(nodeId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .role(role?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetShardingNetworkPublicAddressesPlainArgs].
 */
@PulumiTagMarker
public class GetShardingNetworkPublicAddressesPlainArgsBuilder internal constructor() {
    private var dbInstanceId: String? = null

    private var nodeId: String? = null

    private var outputFile: String? = null

    private var role: String? = null

    /**
     * @param value The db instance id.
     */
    @JvmName("gvkoumfkgxxwtpta")
    public suspend fun dbInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbInstanceId = mapped
    }

    /**
     * @param value The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
     */
    @JvmName("thsscvnuadhryacc")
    public suspend fun nodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nodeId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tpoqeajfjrjfxfks")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The role of the node. Valid values: `Primary` or `Secondary`.
     */
    @JvmName("ykggathanpeygrpi")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.role = mapped
    }

    internal fun build(): GetShardingNetworkPublicAddressesPlainArgs =
        GetShardingNetworkPublicAddressesPlainArgs(
            dbInstanceId = dbInstanceId ?: throw PulumiNullFieldException("dbInstanceId"),
            nodeId = nodeId,
            outputFile = outputFile,
            role = role,
        )
}
