@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.inputs

import com.pulumi.alicloud.mongodb.inputs.ServerlessInstanceSecurityIpGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property securityIpGroupAttribute The attribute of the IP whitelist. This parameter is empty by default.
 * @property securityIpGroupName The name of the IP whitelist.
 * @property securityIpList The IP addresses in the whitelist.
 */
public data class ServerlessInstanceSecurityIpGroupArgs(
    public val securityIpGroupAttribute: Output<String>? = null,
    public val securityIpGroupName: Output<String>? = null,
    public val securityIpList: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.inputs.ServerlessInstanceSecurityIpGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.inputs.ServerlessInstanceSecurityIpGroupArgs =
        com.pulumi.alicloud.mongodb.inputs.ServerlessInstanceSecurityIpGroupArgs.builder()
            .securityIpGroupAttribute(securityIpGroupAttribute?.applyValue({ args0 -> args0 }))
            .securityIpGroupName(securityIpGroupName?.applyValue({ args0 -> args0 }))
            .securityIpList(securityIpList?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessInstanceSecurityIpGroupArgs].
 */
@PulumiTagMarker
public class ServerlessInstanceSecurityIpGroupArgsBuilder internal constructor() {
    private var securityIpGroupAttribute: Output<String>? = null

    private var securityIpGroupName: Output<String>? = null

    private var securityIpList: Output<String>? = null

    /**
     * @param value The attribute of the IP whitelist. This parameter is empty by default.
     */
    @JvmName("crtcnpvfwdvyjtta")
    public suspend fun securityIpGroupAttribute(`value`: Output<String>) {
        this.securityIpGroupAttribute = value
    }

    /**
     * @param value The name of the IP whitelist.
     */
    @JvmName("amweylvljwwrxlgt")
    public suspend fun securityIpGroupName(`value`: Output<String>) {
        this.securityIpGroupName = value
    }

    /**
     * @param value The IP addresses in the whitelist.
     */
    @JvmName("krqwvtanhgvoiayp")
    public suspend fun securityIpList(`value`: Output<String>) {
        this.securityIpList = value
    }

    /**
     * @param value The attribute of the IP whitelist. This parameter is empty by default.
     */
    @JvmName("ggcqpxfvcxhqosah")
    public suspend fun securityIpGroupAttribute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpGroupAttribute = mapped
    }

    /**
     * @param value The name of the IP whitelist.
     */
    @JvmName("vghjapymnqnclpdg")
    public suspend fun securityIpGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpGroupName = mapped
    }

    /**
     * @param value The IP addresses in the whitelist.
     */
    @JvmName("jqvidoleogkmxwpp")
    public suspend fun securityIpList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpList = mapped
    }

    internal fun build(): ServerlessInstanceSecurityIpGroupArgs =
        ServerlessInstanceSecurityIpGroupArgs(
            securityIpGroupAttribute = securityIpGroupAttribute,
            securityIpGroupName = securityIpGroupName,
            securityIpList = securityIpList,
        )
}
