@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.inputs

import com.pulumi.alicloud.mongodb.inputs.ShardingInstanceConfigServerListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectString The connection address of the Config Server node.
 * @property maxConnections The max connections of the Config Server node.
 * @property maxIops The maximum IOPS of the Config Server node.
 * @property nodeClass The instance type of the ConfigServer node. Valid values: `mdb.shard.2x.xlarge.d`, `dds.cs.mid`.
 * @property nodeDescription The description of the Config Server node.
 * @property nodeId The ID of the Config Server node.
 * @property nodeStorage The storage space of the ConfigServer node.
 * @property port The connection port of the Config Server node.
 */
public data class ShardingInstanceConfigServerListArgs(
    public val connectString: Output<String>? = null,
    public val maxConnections: Output<Int>? = null,
    public val maxIops: Output<Int>? = null,
    public val nodeClass: Output<String>? = null,
    public val nodeDescription: Output<String>? = null,
    public val nodeId: Output<String>? = null,
    public val nodeStorage: Output<Int>? = null,
    public val port: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.inputs.ShardingInstanceConfigServerListArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.inputs.ShardingInstanceConfigServerListArgs =
        com.pulumi.alicloud.mongodb.inputs.ShardingInstanceConfigServerListArgs.builder()
            .connectString(connectString?.applyValue({ args0 -> args0 }))
            .maxConnections(maxConnections?.applyValue({ args0 -> args0 }))
            .maxIops(maxIops?.applyValue({ args0 -> args0 }))
            .nodeClass(nodeClass?.applyValue({ args0 -> args0 }))
            .nodeDescription(nodeDescription?.applyValue({ args0 -> args0 }))
            .nodeId(nodeId?.applyValue({ args0 -> args0 }))
            .nodeStorage(nodeStorage?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ShardingInstanceConfigServerListArgs].
 */
@PulumiTagMarker
public class ShardingInstanceConfigServerListArgsBuilder internal constructor() {
    private var connectString: Output<String>? = null

    private var maxConnections: Output<Int>? = null

    private var maxIops: Output<Int>? = null

    private var nodeClass: Output<String>? = null

    private var nodeDescription: Output<String>? = null

    private var nodeId: Output<String>? = null

    private var nodeStorage: Output<Int>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The connection address of the Config Server node.
     */
    @JvmName("eafucsohcbukmqka")
    public suspend fun connectString(`value`: Output<String>) {
        this.connectString = value
    }

    /**
     * @param value The max connections of the Config Server node.
     */
    @JvmName("acggnsivvxbuunuw")
    public suspend fun maxConnections(`value`: Output<Int>) {
        this.maxConnections = value
    }

    /**
     * @param value The maximum IOPS of the Config Server node.
     */
    @JvmName("xinsuveehiaffmev")
    public suspend fun maxIops(`value`: Output<Int>) {
        this.maxIops = value
    }

    /**
     * @param value The instance type of the ConfigServer node. Valid values: `mdb.shard.2x.xlarge.d`, `dds.cs.mid`.
     */
    @JvmName("rxnxmlkjojxfavfw")
    public suspend fun nodeClass(`value`: Output<String>) {
        this.nodeClass = value
    }

    /**
     * @param value The description of the Config Server node.
     */
    @JvmName("amphefghsvgfngqd")
    public suspend fun nodeDescription(`value`: Output<String>) {
        this.nodeDescription = value
    }

    /**
     * @param value The ID of the Config Server node.
     */
    @JvmName("toqclonedasxbfjx")
    public suspend fun nodeId(`value`: Output<String>) {
        this.nodeId = value
    }

    /**
     * @param value The storage space of the ConfigServer node.
     */
    @JvmName("yssepcbybmdbrlqj")
    public suspend fun nodeStorage(`value`: Output<Int>) {
        this.nodeStorage = value
    }

    /**
     * @param value The connection port of the Config Server node.
     */
    @JvmName("ajnxxljhxmqhbiep")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The connection address of the Config Server node.
     */
    @JvmName("sbgvddyuyjpbuttr")
    public suspend fun connectString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectString = mapped
    }

    /**
     * @param value The max connections of the Config Server node.
     */
    @JvmName("obfwounfqptuawnx")
    public suspend fun maxConnections(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConnections = mapped
    }

    /**
     * @param value The maximum IOPS of the Config Server node.
     */
    @JvmName("ttuydwcispknhrgj")
    public suspend fun maxIops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxIops = mapped
    }

    /**
     * @param value The instance type of the ConfigServer node. Valid values: `mdb.shard.2x.xlarge.d`, `dds.cs.mid`.
     */
    @JvmName("msjoswajmwvdiyag")
    public suspend fun nodeClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeClass = mapped
    }

    /**
     * @param value The description of the Config Server node.
     */
    @JvmName("smhorqeovmdpgwsu")
    public suspend fun nodeDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeDescription = mapped
    }

    /**
     * @param value The ID of the Config Server node.
     */
    @JvmName("fwkxfjxmljorefbn")
    public suspend fun nodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeId = mapped
    }

    /**
     * @param value The storage space of the ConfigServer node.
     */
    @JvmName("kexecebbrwenqysg")
    public suspend fun nodeStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeStorage = mapped
    }

    /**
     * @param value The connection port of the Config Server node.
     */
    @JvmName("wtcouoihgoibqygq")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): ShardingInstanceConfigServerListArgs = ShardingInstanceConfigServerListArgs(
        connectString = connectString,
        maxConnections = maxConnections,
        maxIops = maxIops,
        nodeClass = nodeClass,
        nodeDescription = nodeDescription,
        nodeId = nodeId,
        nodeStorage = nodeStorage,
        port = port,
    )
}
