@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.inputs

import com.pulumi.alicloud.mongodb.inputs.ShardingInstanceMongoListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectString The connection address of the Config Server node.
 * @property nodeClass The instance type of the mongo node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
 * @property nodeId The ID of the Config Server node.
 * @property port The connection port of the Config Server node.
 */
public data class ShardingInstanceMongoListArgs(
    public val connectString: Output<String>? = null,
    public val nodeClass: Output<String>,
    public val nodeId: Output<String>? = null,
    public val port: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.inputs.ShardingInstanceMongoListArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.inputs.ShardingInstanceMongoListArgs =
        com.pulumi.alicloud.mongodb.inputs.ShardingInstanceMongoListArgs.builder()
            .connectString(connectString?.applyValue({ args0 -> args0 }))
            .nodeClass(nodeClass.applyValue({ args0 -> args0 }))
            .nodeId(nodeId?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ShardingInstanceMongoListArgs].
 */
@PulumiTagMarker
public class ShardingInstanceMongoListArgsBuilder internal constructor() {
    private var connectString: Output<String>? = null

    private var nodeClass: Output<String>? = null

    private var nodeId: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The connection address of the Config Server node.
     */
    @JvmName("louieprmvpqrrhgf")
    public suspend fun connectString(`value`: Output<String>) {
        this.connectString = value
    }

    /**
     * @param value The instance type of the mongo node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
     */
    @JvmName("nkkqnalafvxljcrb")
    public suspend fun nodeClass(`value`: Output<String>) {
        this.nodeClass = value
    }

    /**
     * @param value The ID of the Config Server node.
     */
    @JvmName("wmhutoqvsqyatabu")
    public suspend fun nodeId(`value`: Output<String>) {
        this.nodeId = value
    }

    /**
     * @param value The connection port of the Config Server node.
     */
    @JvmName("mtwhpaciramilcsv")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The connection address of the Config Server node.
     */
    @JvmName("levhqvjylspkcxky")
    public suspend fun connectString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectString = mapped
    }

    /**
     * @param value The instance type of the mongo node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
     */
    @JvmName("jojwykxwrsiwwgdv")
    public suspend fun nodeClass(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeClass = mapped
    }

    /**
     * @param value The ID of the Config Server node.
     */
    @JvmName("rjxxuwndkcibxrsf")
    public suspend fun nodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeId = mapped
    }

    /**
     * @param value The connection port of the Config Server node.
     */
    @JvmName("etlbqvmmlfumyyag")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): ShardingInstanceMongoListArgs = ShardingInstanceMongoListArgs(
        connectString = connectString,
        nodeClass = nodeClass ?: throw PulumiNullFieldException("nodeClass"),
        nodeId = nodeId,
        port = port,
    )
}
