@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.inputs

import com.pulumi.alicloud.mongodb.inputs.ShardingInstanceShardListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property nodeClass The instance type of the shard node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
 * @property nodeId The ID of the Config Server node.
 * @property nodeStorage The storage space of the shard node.
 * - Custom storage space; value range: [10, 1,000]
 * - 10-GB increments. Unit: GB.
 * @property readonlyReplicas The number of read-only nodes in shard node Default value: `0`. Valid values: `0` to `5`.
 */
public data class ShardingInstanceShardListArgs(
    public val nodeClass: Output<String>,
    public val nodeId: Output<String>? = null,
    public val nodeStorage: Output<Int>,
    public val readonlyReplicas: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.inputs.ShardingInstanceShardListArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.inputs.ShardingInstanceShardListArgs =
        com.pulumi.alicloud.mongodb.inputs.ShardingInstanceShardListArgs.builder()
            .nodeClass(nodeClass.applyValue({ args0 -> args0 }))
            .nodeId(nodeId?.applyValue({ args0 -> args0 }))
            .nodeStorage(nodeStorage.applyValue({ args0 -> args0 }))
            .readonlyReplicas(readonlyReplicas?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ShardingInstanceShardListArgs].
 */
@PulumiTagMarker
public class ShardingInstanceShardListArgsBuilder internal constructor() {
    private var nodeClass: Output<String>? = null

    private var nodeId: Output<String>? = null

    private var nodeStorage: Output<Int>? = null

    private var readonlyReplicas: Output<Int>? = null

    /**
     * @param value The instance type of the shard node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
     */
    @JvmName("qhdmonlrmawprdwy")
    public suspend fun nodeClass(`value`: Output<String>) {
        this.nodeClass = value
    }

    /**
     * @param value The ID of the Config Server node.
     */
    @JvmName("sofelpyoagbkonkq")
    public suspend fun nodeId(`value`: Output<String>) {
        this.nodeId = value
    }

    /**
     * @param value The storage space of the shard node.
     * - Custom storage space; value range: [10, 1,000]
     * - 10-GB increments. Unit: GB.
     */
    @JvmName("mjrycwqspefkcedb")
    public suspend fun nodeStorage(`value`: Output<Int>) {
        this.nodeStorage = value
    }

    /**
     * @param value The number of read-only nodes in shard node Default value: `0`. Valid values: `0` to `5`.
     */
    @JvmName("jrjawtstxiqylwss")
    public suspend fun readonlyReplicas(`value`: Output<Int>) {
        this.readonlyReplicas = value
    }

    /**
     * @param value The instance type of the shard node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
     */
    @JvmName("pamlkxoghotvvuev")
    public suspend fun nodeClass(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeClass = mapped
    }

    /**
     * @param value The ID of the Config Server node.
     */
    @JvmName("oefgmqucnkebchit")
    public suspend fun nodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeId = mapped
    }

    /**
     * @param value The storage space of the shard node.
     * - Custom storage space; value range: [10, 1,000]
     * - 10-GB increments. Unit: GB.
     */
    @JvmName("xoxttihdakopgkyg")
    public suspend fun nodeStorage(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeStorage = mapped
    }

    /**
     * @param value The number of read-only nodes in shard node Default value: `0`. Valid values: `0` to `5`.
     */
    @JvmName("kgrutcouhruwigju")
    public suspend fun readonlyReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readonlyReplicas = mapped
    }

    internal fun build(): ShardingInstanceShardListArgs = ShardingInstanceShardListArgs(
        nodeClass = nodeClass ?: throw PulumiNullFieldException("nodeClass"),
        nodeId = nodeId,
        nodeStorage = nodeStorage ?: throw PulumiNullFieldException("nodeStorage"),
        readonlyReplicas = readonlyReplicas,
    )
}
