@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountDescription The description of the account.
 * @property accountName The name of the account.
 * @property characterType The role of the account. Valid values: `db`, `cs`, `mongos`, `logic`, `normal`.
 * @property id The ID of the Account. The value formats as `<instance_id>:<account_name>`.
 * @property instanceId The id of the instance to which the account belongs.
 * @property status The status of the account. Valid values: `Unavailable`, `Available`.
 */
public data class GetAccountsAccount(
    public val accountDescription: String,
    public val accountName: String,
    public val characterType: String,
    public val id: String,
    public val instanceId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.GetAccountsAccount): GetAccountsAccount = GetAccountsAccount(
            accountDescription = javaType.accountDescription(),
            accountName = javaType.accountName(),
            characterType = javaType.characterType(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            status = javaType.status(),
        )
    }
}
