@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccounts.
 * @property accountName
 * @property accounts
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property outputFile
 */
public data class GetAccountsResult(
    public val accountName: String? = null,
    public val accounts: List<GetAccountsAccount>,
    public val id: String,
    public val instanceId: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.GetAccountsResult): GetAccountsResult = GetAccountsResult(
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            accounts = javaType.accounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mongodb.kotlin.outputs.GetAccountsAccount.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
