@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property auditStatus The status of the log audit feature.
 * @property dbInstanceId The ID of the instance.
 * @property id The ID of the Audit Policy.
 */
public data class GetAuditPoliciesPolicy(
    public val auditStatus: String,
    public val dbInstanceId: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.GetAuditPoliciesPolicy): GetAuditPoliciesPolicy = GetAuditPoliciesPolicy(
            auditStatus = javaType.auditStatus(),
            dbInstanceId = javaType.dbInstanceId(),
            id = javaType.id(),
        )
    }
}
