@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAuditPolicies.
 * @property dbInstanceId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property policies
 */
public data class GetAuditPoliciesResult(
    public val dbInstanceId: String,
    public val id: String,
    public val outputFile: String? = null,
    public val policies: List<GetAuditPoliciesPolicy>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.GetAuditPoliciesResult): GetAuditPoliciesResult = GetAuditPoliciesResult(
            dbInstanceId = javaType.dbInstanceId(),
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mongodb.kotlin.outputs.GetAuditPoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
