@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property availabilityZone Instance availability zone.
 * @property chargeType Billing method. Value options are `PostPaid` for  Pay-As-You-Go and `PrePaid` for yearly or monthly subscription.
 * @property creationTime Creation time of the instance in RFC3339 format.
 * @property engine Database engine type. Supported option is `MongoDB`.
 * @property engineVersion Database engine version.
 * @property expirationTime Expiration time in RFC3339 format. Pay-As-You-Go instances are never expire.
 * @property id The ID of the MongoDB instance.
 * @property instanceClass Sizing of the instance to be queried.
 * @property instanceType Type of the instance to be queried. If it is set to `sharding`, the sharded cluster instances are listed. If it is set to `replicate`, replica set instances are listed. Default value `replicate`.
 * @property lockMode Lock status of the instance.
 * @property mongos Array composed of Mongos.
 * @property name The name of the MongoDB instance.
 * @property networkType Classic network or VPC.
 * @property regionId Region ID the instance belongs to.
 * @property replication Replication factor corresponds to number of nodes. Optional values are `1` for single node and `3` for three nodes replica set.
 * @property shards Array composed of shards.
 * @property status Status of the instance.
 * @property storage Shard disk.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetInstancesInstance(
    public val availabilityZone: String,
    public val chargeType: String,
    public val creationTime: String,
    public val engine: String,
    public val engineVersion: String,
    public val expirationTime: String,
    public val id: String,
    public val instanceClass: String,
    public val instanceType: String,
    public val lockMode: String,
    public val mongos: List<GetInstancesInstanceMongo>,
    public val name: String,
    public val networkType: String,
    public val regionId: String,
    public val replication: String,
    public val shards: List<GetInstancesInstanceShard>,
    public val status: String,
    public val storage: Int,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            availabilityZone = javaType.availabilityZone(),
            chargeType = javaType.chargeType(),
            creationTime = javaType.creationTime(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            expirationTime = javaType.expirationTime(),
            id = javaType.id(),
            instanceClass = javaType.instanceClass(),
            instanceType = javaType.instanceType(),
            lockMode = javaType.lockMode(),
            mongos = javaType.mongos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mongodb.kotlin.outputs.GetInstancesInstanceMongo.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            networkType = javaType.networkType(),
            regionId = javaType.regionId(),
            replication = javaType.replication(),
            shards = javaType.shards().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mongodb.kotlin.outputs.GetInstancesInstanceShard.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            storage = javaType.storage(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
