@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInstances.
 * @property availabilityZone Instance availability zone.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids The ids list of MongoDB instances
 * @property instanceClass Sizing of the MongoDB instance.
 * @property instanceType Instance type. Optional values `sharding` or `replicate`.
 * @property instances A list of MongoDB instances. Its every element contains the following attributes:
 * @property nameRegex
 * @property names The names list of MongoDB instances
 * @property outputFile
 * @property tags
 */
public data class GetInstancesResult(
    public val availabilityZone: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceClass: String? = null,
    public val instanceType: String? = null,
    public val instances: List<GetInstancesInstance>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceClass = javaType.instanceClass().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mongodb.kotlin.outputs.GetInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
