@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property capacityUnit The read/write throughput consumed by the instance.
 * @property dbInstanceClass The db instance class.
 * @property dbInstanceDescription The db instance description.
 * @property dbInstanceId The db instance id.
 * @property dbInstanceReleaseProtection The db instance release protection.
 * @property dbInstanceStorage The db instance storage.
 * @property engine The database engine of the instance.
 * @property engineVersion The database version number. Valid values: `4.2`.
 * @property expireTime The time when the subscription instance expires. The time is in the `yyyy-MM-ddTHH:mmZ` format. The time is displayed in UTC.
 * @property id The ID of the Serverless Instance.
 * @property kindCode Indicates the type of the instance. Valid values: `0`: physical machine. `1`: ECS. `2`: DOCKER. `18`: k8s new architecture instance.
 * @property lockMode The locked status of the instance.
 * @property maintainEndTime The start time of the maintenance window. The time is in the `HH:mmZ` format. The time is displayed in UTC.
 * @property maintainStartTime The end time of the maintenance window. The time is in the `HH:mmZ` format. The time is displayed in UTC.
 * @property maxConnections Instance maximum connections.
 * @property maxIops The maximum IOPS of the instance.
 * @property networkType The network type of the instance.
 * @property paymentType The Payment type of the instance.
 * @property protocolType The access protocol type of the instance. Valid values: `mongodb`, `dynamodb`.
 * @property resourceGroupId The ID of the resource group.
 * @property securityIpGroups The security ip list.
 * @property status The status of the instance.
 * @property storageEngine The storage engine used by the instance.
 * @property tags The tag of the resource.
 * @property vpcAuthMode Intranet secret free access mode.
 * @property vpcId The ID of the VPC network.
 * @property vswitchId The id of the vswitch.
 * @property zoneId The ID of the zone.
 */
public data class GetServerlessInstancesInstance(
    public val capacityUnit: Int,
    public val dbInstanceClass: String,
    public val dbInstanceDescription: String,
    public val dbInstanceId: String,
    public val dbInstanceReleaseProtection: Boolean,
    public val dbInstanceStorage: Int,
    public val engine: String,
    public val engineVersion: String,
    public val expireTime: String,
    public val id: String,
    public val kindCode: String,
    public val lockMode: String,
    public val maintainEndTime: String,
    public val maintainStartTime: String,
    public val maxConnections: Int,
    public val maxIops: Int,
    public val networkType: String,
    public val paymentType: String,
    public val protocolType: String,
    public val resourceGroupId: String,
    public val securityIpGroups: List<GetServerlessInstancesInstanceSecurityIpGroup>,
    public val status: String,
    public val storageEngine: String,
    public val tags: Map<String, String>,
    public val vpcAuthMode: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.GetServerlessInstancesInstance): GetServerlessInstancesInstance = GetServerlessInstancesInstance(
            capacityUnit = javaType.capacityUnit(),
            dbInstanceClass = javaType.dbInstanceClass(),
            dbInstanceDescription = javaType.dbInstanceDescription(),
            dbInstanceId = javaType.dbInstanceId(),
            dbInstanceReleaseProtection = javaType.dbInstanceReleaseProtection(),
            dbInstanceStorage = javaType.dbInstanceStorage(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            kindCode = javaType.kindCode(),
            lockMode = javaType.lockMode(),
            maintainEndTime = javaType.maintainEndTime(),
            maintainStartTime = javaType.maintainStartTime(),
            maxConnections = javaType.maxConnections(),
            maxIops = javaType.maxIops(),
            networkType = javaType.networkType(),
            paymentType = javaType.paymentType(),
            protocolType = javaType.protocolType(),
            resourceGroupId = javaType.resourceGroupId(),
            securityIpGroups = javaType.securityIpGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mongodb.kotlin.outputs.GetServerlessInstancesInstanceSecurityIpGroup.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            storageEngine = javaType.storageEngine(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcAuthMode = javaType.vpcAuthMode(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
