@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getShardingNetworkPrivateAddresses.
 * @property addresses
 * @property dbInstanceId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property nodeId
 * @property outputFile
 * @property role
 */
public data class GetShardingNetworkPrivateAddressesResult(
    public val addresses: List<GetShardingNetworkPrivateAddressesAddress>,
    public val dbInstanceId: String,
    public val id: String,
    public val nodeId: String? = null,
    public val outputFile: String? = null,
    public val role: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.GetShardingNetworkPrivateAddressesResult): GetShardingNetworkPrivateAddressesResult = GetShardingNetworkPrivateAddressesResult(
            addresses = javaType.addresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mongodb.kotlin.outputs.GetShardingNetworkPrivateAddressesAddress.Companion.toKotlin(args0)
                })
            }),
            dbInstanceId = javaType.dbInstanceId(),
            id = javaType.id(),
            nodeId = javaType.nodeId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
        )
    }
}
