@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dbInstanceId The db instance id.
 * @property expiredTime The remaining duration of the classic network address. Unit: `seconds`.
 * @property ipAddress The IP address of the instance.
 * @property networkAddress The endpoint of the instance.
 * @property networkType The network type.
 * @property nodeId The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
 * @property nodeType The type of the node.
 * @property port The port number.
 * @property role The role of the node.
 * @property vpcId The ID of the VPC.
 * @property vswitchId The vSwitch ID of the VPC.
 */
public data class GetShardingNetworkPublicAddressesAddress(
    public val dbInstanceId: String,
    public val expiredTime: String,
    public val ipAddress: String,
    public val networkAddress: String,
    public val networkType: String,
    public val nodeId: String,
    public val nodeType: String,
    public val port: String,
    public val role: String,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.GetShardingNetworkPublicAddressesAddress): GetShardingNetworkPublicAddressesAddress = GetShardingNetworkPublicAddressesAddress(
            dbInstanceId = javaType.dbInstanceId(),
            expiredTime = javaType.expiredTime(),
            ipAddress = javaType.ipAddress(),
            networkAddress = javaType.networkAddress(),
            networkType = javaType.networkType(),
            nodeId = javaType.nodeId(),
            nodeType = javaType.nodeType(),
            port = javaType.port(),
            role = javaType.role(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
