@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectionDomain The connection address of the node.
 * @property connectionPort The connection port of the node.
 * @property networkType The network type of the instance. Valid values:`Classic`, `VPC`.
 * @property replicaSetRole The role of the node.
 * @property vpcCloudInstanceId VPC instance ID.
 * @property vpcId The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
 * @property vswitchId The virtual switch ID to launch DB instances in one VPC.
 */
public data class InstanceReplicaSet(
    public val connectionDomain: String? = null,
    public val connectionPort: String? = null,
    public val networkType: String? = null,
    public val replicaSetRole: String? = null,
    public val vpcCloudInstanceId: String? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.InstanceReplicaSet): InstanceReplicaSet = InstanceReplicaSet(
            connectionDomain = javaType.connectionDomain().map({ args0 -> args0 }).orElse(null),
            connectionPort = javaType.connectionPort().map({ args0 -> args0 }).orElse(null),
            networkType = javaType.networkType().map({ args0 -> args0 }).orElse(null),
            replicaSetRole = javaType.replicaSetRole().map({ args0 -> args0 }).orElse(null),
            vpcCloudInstanceId = javaType.vpcCloudInstanceId().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
