@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectString The connection address of the Config Server node.
 * @property maxConnections The max connections of the Config Server node.
 * @property maxIops The maximum IOPS of the Config Server node.
 * @property nodeClass The instance type of the ConfigServer node. Valid values: `mdb.shard.2x.xlarge.d`, `dds.cs.mid`.
 * @property nodeDescription The description of the Config Server node.
 * @property nodeId The ID of the Config Server node.
 * @property nodeStorage The storage space of the ConfigServer node.
 * @property port The connection port of the Config Server node.
 */
public data class ShardingInstanceConfigServerList(
    public val connectString: String? = null,
    public val maxConnections: Int? = null,
    public val maxIops: Int? = null,
    public val nodeClass: String? = null,
    public val nodeDescription: String? = null,
    public val nodeId: String? = null,
    public val nodeStorage: Int? = null,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.ShardingInstanceConfigServerList): ShardingInstanceConfigServerList = ShardingInstanceConfigServerList(
            connectString = javaType.connectString().map({ args0 -> args0 }).orElse(null),
            maxConnections = javaType.maxConnections().map({ args0 -> args0 }).orElse(null),
            maxIops = javaType.maxIops().map({ args0 -> args0 }).orElse(null),
            nodeClass = javaType.nodeClass().map({ args0 -> args0 }).orElse(null),
            nodeDescription = javaType.nodeDescription().map({ args0 -> args0 }).orElse(null),
            nodeId = javaType.nodeId().map({ args0 -> args0 }).orElse(null),
            nodeStorage = javaType.nodeStorage().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
