@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectString The connection address of the Config Server node.
 * @property nodeClass The instance type of the mongo node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
 * @property nodeId The ID of the Config Server node.
 * @property port The connection port of the Config Server node.
 */
public data class ShardingInstanceMongoList(
    public val connectString: String? = null,
    public val nodeClass: String,
    public val nodeId: String? = null,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.ShardingInstanceMongoList): ShardingInstanceMongoList = ShardingInstanceMongoList(
            connectString = javaType.connectString().map({ args0 -> args0 }).orElse(null),
            nodeClass = javaType.nodeClass(),
            nodeId = javaType.nodeId().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
