@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property nodeClass The instance type of the shard node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
 * @property nodeId The ID of the Config Server node.
 * @property nodeStorage The storage space of the shard node.
 * - Custom storage space; value range: [10, 1,000]
 * - 10-GB increments. Unit: GB.
 * @property readonlyReplicas The number of read-only nodes in shard node Default value: `0`. Valid values: `0` to `5`.
 */
public data class ShardingInstanceShardList(
    public val nodeClass: String,
    public val nodeId: String? = null,
    public val nodeStorage: Int,
    public val readonlyReplicas: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.ShardingInstanceShardList): ShardingInstanceShardList = ShardingInstanceShardList(
            nodeClass = javaType.nodeClass(),
            nodeId = javaType.nodeId().map({ args0 -> args0 }).orElse(null),
            nodeStorage = javaType.nodeStorage(),
            readonlyReplicas = javaType.readonlyReplicas().map({ args0 -> args0 }).orElse(null),
        )
    }
}
