@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property expiredTime The remaining duration of the classic network endpoint.
 * @property ipAddress The IP address of the instance.
 * @property networkAddress The connection string of the instance.
 * @property networkType The network type of the instance.
 * @property nodeId The ID of the Shard node or ConfigServer node.
 * @property nodeType The type of the node.
 * @property port The port that is used to connect to the instance.
 * @property role The role of the node.
 * @property vpcId The ID of the VPC.
 * @property vswitchId The ID of the vSwitch in the VPC.
 */
public data class ShardingNetworkPrivateAddressNetworkAddress(
    public val expiredTime: String? = null,
    public val ipAddress: String? = null,
    public val networkAddress: String? = null,
    public val networkType: String? = null,
    public val nodeId: String? = null,
    public val nodeType: String? = null,
    public val port: String? = null,
    public val role: String? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mongodb.outputs.ShardingNetworkPrivateAddressNetworkAddress): ShardingNetworkPrivateAddressNetworkAddress = ShardingNetworkPrivateAddressNetworkAddress(
            expiredTime = javaType.expiredTime().map({ args0 -> args0 }).orElse(null),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            networkAddress = javaType.networkAddress().map({ args0 -> args0 }).orElse(null),
            networkType = javaType.networkType().map({ args0 -> args0 }).orElse(null),
            nodeId = javaType.nodeId().map({ args0 -> args0 }).orElse(null),
            nodeType = javaType.nodeType().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
