@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.alicloud.mse.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * MSE Cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mse/cluster:Cluster example mse-cn-0d9xxxx
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.alicloud.mse.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
     */
    public val aclEntryLists: Output<List<String>>?
        get() = javaResource.aclEntryLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * (Available in v1.205.0+) The application version.
     */
    public val appVersion: Output<String>
        get() = javaResource.appVersion().applyValue({ args0 -> args0 })

    /**
     * The alias of MSE Cluster.
     */
    public val clusterAliasName: Output<String>?
        get() = javaResource.clusterAliasName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * (Available in v1.162.0+) The id of Cluster.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The engine specification of MSE Cluster. **NOTE:** From version 1.188.0, `cluster_specification` can be modified. Valid values:
     * - `MSE_SC_1_2_60_c`: 1C2G
     * - `MSE_SC_2_4_60_c`: 2C4G
     * - `MSE_SC_4_8_60_c`: 4C8G
     * - `MSE_SC_8_16_60_c`: 8C16G
     */
    public val clusterSpecification: Output<String>
        get() = javaResource.clusterSpecification().applyValue({ args0 -> args0 })

    /**
     * The type of MSE Cluster.
     */
    public val clusterType: Output<String>
        get() = javaResource.clusterType().applyValue({ args0 -> args0 })

    /**
     * The version of MSE Cluster. See [details](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createcluster)
     */
    public val clusterVersion: Output<String>
        get() = javaResource.clusterVersion().applyValue({ args0 -> args0 })

    /**
     * The connection type. Valid values: `slb`.
     */
    public val connectionType: Output<String>
        get() = javaResource.connectionType().applyValue({ args0 -> args0 })

    /**
     * The type of Disk.
     */
    public val diskType: Output<String>?
        get() = javaResource.diskType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The count of instance. **NOTE:** From version 1.188.0, `instance_count` can be modified.
     */
    public val instanceCount: Output<Int>
        get() = javaResource.instanceCount().applyValue({ args0 -> args0 })

    /**
     * The version of MSE. Valid values: `mse_dev` or `mse_pro`.
     */
    public val mseVersion: Output<String>
        get() = javaResource.mseVersion().applyValue({ args0 -> args0 })

    /**
     * The type of network. Valid values: "privatenet" and "pubnet".
     */
    public val netType: Output<String>
        get() = javaResource.netType().applyValue({ args0 -> args0 })

    /**
     * Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The specification of private network SLB.
     */
    public val privateSlbSpecification: Output<String>?
        get() = javaResource.privateSlbSpecification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The public network bandwidth. `0` means no access to the public network.
     */
    public val pubNetworkFlow: Output<String>
        get() = javaResource.pubNetworkFlow().applyValue({ args0 -> args0 })

    /**
     * The specification of public network SLB.
     */
    public val pubSlbSpecification: Output<String>?
        get() = javaResource.pubSlbSpecification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The extended request parameters in the JSON format.
     */
    public val requestPars: Output<String>?
        get() = javaResource.requestPars().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource group of the resource.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of MSE Cluster.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The id of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The id of VSwitch.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.mse.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.alicloud.mse.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
