@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin

import com.pulumi.alicloud.mse.ClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * MSE Cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mse/cluster:Cluster example mse-cn-0d9xxxx
 * ```
 * @property aclEntryLists The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
 * @property clusterAliasName The alias of MSE Cluster.
 * @property clusterSpecification The engine specification of MSE Cluster. **NOTE:** From version 1.188.0, `cluster_specification` can be modified. Valid values:
 * - `MSE_SC_1_2_60_c`: 1C2G
 * - `MSE_SC_2_4_60_c`: 2C4G
 * - `MSE_SC_4_8_60_c`: 4C8G
 * - `MSE_SC_8_16_60_c`: 8C16G
 * @property clusterType The type of MSE Cluster.
 * @property clusterVersion The version of MSE Cluster. See [details](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createcluster)
 * @property connectionType The connection type. Valid values: `slb`.
 * @property diskType The type of Disk.
 * @property instanceCount The count of instance. **NOTE:** From version 1.188.0, `instance_count` can be modified.
 * @property mseVersion The version of MSE. Valid values: `mse_dev` or `mse_pro`.
 * @property netType The type of network. Valid values: "privatenet" and "pubnet".
 * @property paymentType Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo.
 * @property privateSlbSpecification The specification of private network SLB.
 * @property pubNetworkFlow The public network bandwidth. `0` means no access to the public network.
 * @property pubSlbSpecification The specification of public network SLB.
 * @property requestPars The extended request parameters in the JSON format.
 * @property resourceGroupId The resource group of the resource.
 * @property tags The tag of the resource.
 * @property vpcId The id of the VPC.
 * @property vswitchId The id of VSwitch.
 */
public data class ClusterArgs(
    public val aclEntryLists: Output<List<String>>? = null,
    public val clusterAliasName: Output<String>? = null,
    public val clusterSpecification: Output<String>? = null,
    public val clusterType: Output<String>? = null,
    public val clusterVersion: Output<String>? = null,
    public val connectionType: Output<String>? = null,
    public val diskType: Output<String>? = null,
    public val instanceCount: Output<Int>? = null,
    public val mseVersion: Output<String>? = null,
    public val netType: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val privateSlbSpecification: Output<String>? = null,
    public val pubNetworkFlow: Output<String>? = null,
    public val pubSlbSpecification: Output<String>? = null,
    public val requestPars: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mse.ClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.mse.ClusterArgs =
        com.pulumi.alicloud.mse.ClusterArgs.builder()
            .aclEntryLists(aclEntryLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clusterAliasName(clusterAliasName?.applyValue({ args0 -> args0 }))
            .clusterSpecification(clusterSpecification?.applyValue({ args0 -> args0 }))
            .clusterType(clusterType?.applyValue({ args0 -> args0 }))
            .clusterVersion(clusterVersion?.applyValue({ args0 -> args0 }))
            .connectionType(connectionType?.applyValue({ args0 -> args0 }))
            .diskType(diskType?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .mseVersion(mseVersion?.applyValue({ args0 -> args0 }))
            .netType(netType?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .privateSlbSpecification(privateSlbSpecification?.applyValue({ args0 -> args0 }))
            .pubNetworkFlow(pubNetworkFlow?.applyValue({ args0 -> args0 }))
            .pubSlbSpecification(pubSlbSpecification?.applyValue({ args0 -> args0 }))
            .requestPars(requestPars?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var aclEntryLists: Output<List<String>>? = null

    private var clusterAliasName: Output<String>? = null

    private var clusterSpecification: Output<String>? = null

    private var clusterType: Output<String>? = null

    private var clusterVersion: Output<String>? = null

    private var connectionType: Output<String>? = null

    private var diskType: Output<String>? = null

    private var instanceCount: Output<Int>? = null

    private var mseVersion: Output<String>? = null

    private var netType: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var privateSlbSpecification: Output<String>? = null

    private var pubNetworkFlow: Output<String>? = null

    private var pubSlbSpecification: Output<String>? = null

    private var requestPars: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
     */
    @JvmName("jwjlqnwyxteejaik")
    public suspend fun aclEntryLists(`value`: Output<List<String>>) {
        this.aclEntryLists = value
    }

    @JvmName("kjcrboiqwxjpqhid")
    public suspend fun aclEntryLists(vararg values: Output<String>) {
        this.aclEntryLists = Output.all(values.asList())
    }

    /**
     * @param values The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
     */
    @JvmName("ictrafoiqfvidkil")
    public suspend fun aclEntryLists(values: List<Output<String>>) {
        this.aclEntryLists = Output.all(values)
    }

    /**
     * @param value The alias of MSE Cluster.
     */
    @JvmName("yliakjptcubeutpm")
    public suspend fun clusterAliasName(`value`: Output<String>) {
        this.clusterAliasName = value
    }

    /**
     * @param value The engine specification of MSE Cluster. **NOTE:** From version 1.188.0, `cluster_specification` can be modified. Valid values:
     * - `MSE_SC_1_2_60_c`: 1C2G
     * - `MSE_SC_2_4_60_c`: 2C4G
     * - `MSE_SC_4_8_60_c`: 4C8G
     * - `MSE_SC_8_16_60_c`: 8C16G
     */
    @JvmName("qyleffxholydkugq")
    public suspend fun clusterSpecification(`value`: Output<String>) {
        this.clusterSpecification = value
    }

    /**
     * @param value The type of MSE Cluster.
     */
    @JvmName("fevmanklrattifko")
    public suspend fun clusterType(`value`: Output<String>) {
        this.clusterType = value
    }

    /**
     * @param value The version of MSE Cluster. See [details](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createcluster)
     */
    @JvmName("absdenfhtwbfjifg")
    public suspend fun clusterVersion(`value`: Output<String>) {
        this.clusterVersion = value
    }

    /**
     * @param value The connection type. Valid values: `slb`.
     */
    @JvmName("rcqfetydylggfvvt")
    public suspend fun connectionType(`value`: Output<String>) {
        this.connectionType = value
    }

    /**
     * @param value The type of Disk.
     */
    @JvmName("awygrodychjsgrml")
    public suspend fun diskType(`value`: Output<String>) {
        this.diskType = value
    }

    /**
     * @param value The count of instance. **NOTE:** From version 1.188.0, `instance_count` can be modified.
     */
    @JvmName("ftkdtajnlgxccsat")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value The version of MSE. Valid values: `mse_dev` or `mse_pro`.
     */
    @JvmName("iqkkesgwtreajnag")
    public suspend fun mseVersion(`value`: Output<String>) {
        this.mseVersion = value
    }

    /**
     * @param value The type of network. Valid values: "privatenet" and "pubnet".
     */
    @JvmName("yvnexcoynmdqdbkw")
    public suspend fun netType(`value`: Output<String>) {
        this.netType = value
    }

    /**
     * @param value Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo.
     */
    @JvmName("sboslxrjtletaqrh")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The specification of private network SLB.
     */
    @JvmName("xnuugeoagcuhpjeh")
    public suspend fun privateSlbSpecification(`value`: Output<String>) {
        this.privateSlbSpecification = value
    }

    /**
     * @param value The public network bandwidth. `0` means no access to the public network.
     */
    @JvmName("jjvmtmchtytykrao")
    public suspend fun pubNetworkFlow(`value`: Output<String>) {
        this.pubNetworkFlow = value
    }

    /**
     * @param value The specification of public network SLB.
     */
    @JvmName("hjeukimjqpxvwlpm")
    public suspend fun pubSlbSpecification(`value`: Output<String>) {
        this.pubSlbSpecification = value
    }

    /**
     * @param value The extended request parameters in the JSON format.
     */
    @JvmName("atxmedcdirlselip")
    public suspend fun requestPars(`value`: Output<String>) {
        this.requestPars = value
    }

    /**
     * @param value The resource group of the resource.
     */
    @JvmName("lxknmijvaiqnubij")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("roqvvhmwoiqpccty")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The id of the VPC.
     */
    @JvmName("nqnxnqtsbjpayhso")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The id of VSwitch.
     */
    @JvmName("quarfcaffimluvmj")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
     */
    @JvmName("abposskcacamvfwk")
    public suspend fun aclEntryLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclEntryLists = mapped
    }

    /**
     * @param values The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
     */
    @JvmName("jwmxetyvkwnemdsf")
    public suspend fun aclEntryLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aclEntryLists = mapped
    }

    /**
     * @param value The alias of MSE Cluster.
     */
    @JvmName("wpxhxvhwlcahcthn")
    public suspend fun clusterAliasName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterAliasName = mapped
    }

    /**
     * @param value The engine specification of MSE Cluster. **NOTE:** From version 1.188.0, `cluster_specification` can be modified. Valid values:
     * - `MSE_SC_1_2_60_c`: 1C2G
     * - `MSE_SC_2_4_60_c`: 2C4G
     * - `MSE_SC_4_8_60_c`: 4C8G
     * - `MSE_SC_8_16_60_c`: 8C16G
     */
    @JvmName("qnurtfphbyovntas")
    public suspend fun clusterSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSpecification = mapped
    }

    /**
     * @param value The type of MSE Cluster.
     */
    @JvmName("tcgakwmxvywfgejc")
    public suspend fun clusterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterType = mapped
    }

    /**
     * @param value The version of MSE Cluster. See [details](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createcluster)
     */
    @JvmName("ulhlalbmymulvvwa")
    public suspend fun clusterVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterVersion = mapped
    }

    /**
     * @param value The connection type. Valid values: `slb`.
     */
    @JvmName("lvuannrcwjbunkjn")
    public suspend fun connectionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param value The type of Disk.
     */
    @JvmName("pgchbklgiewgwoud")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The count of instance. **NOTE:** From version 1.188.0, `instance_count` can be modified.
     */
    @JvmName("muasthonujupqyxr")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value The version of MSE. Valid values: `mse_dev` or `mse_pro`.
     */
    @JvmName("wceykemjcnlkvkwa")
    public suspend fun mseVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mseVersion = mapped
    }

    /**
     * @param value The type of network. Valid values: "privatenet" and "pubnet".
     */
    @JvmName("dptarllybxcmeaqr")
    public suspend fun netType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netType = mapped
    }

    /**
     * @param value Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo.
     */
    @JvmName("ybpdexlgcrdcpjtn")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The specification of private network SLB.
     */
    @JvmName("xiolvhaqpeepfdbh")
    public suspend fun privateSlbSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateSlbSpecification = mapped
    }

    /**
     * @param value The public network bandwidth. `0` means no access to the public network.
     */
    @JvmName("jmbbilbsiovchtof")
    public suspend fun pubNetworkFlow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pubNetworkFlow = mapped
    }

    /**
     * @param value The specification of public network SLB.
     */
    @JvmName("wuscgevoirsxlsbk")
    public suspend fun pubSlbSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pubSlbSpecification = mapped
    }

    /**
     * @param value The extended request parameters in the JSON format.
     */
    @JvmName("tbmtypivohlkngri")
    public suspend fun requestPars(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestPars = mapped
    }

    /**
     * @param value The resource group of the resource.
     */
    @JvmName("rkhataiiynmurhsu")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("ndvfufspkxpypnna")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("hgtmubgmnwhbstnf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The id of the VPC.
     */
    @JvmName("xosbjcoohpgqjfgt")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The id of VSwitch.
     */
    @JvmName("xunrnnlhafepcffy")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        aclEntryLists = aclEntryLists,
        clusterAliasName = clusterAliasName,
        clusterSpecification = clusterSpecification,
        clusterType = clusterType,
        clusterVersion = clusterVersion,
        connectionType = connectionType,
        diskType = diskType,
        instanceCount = instanceCount,
        mseVersion = mseVersion,
        netType = netType,
        paymentType = paymentType,
        privateSlbSpecification = privateSlbSpecification,
        pubNetworkFlow = pubNetworkFlow,
        pubSlbSpecification = pubSlbSpecification,
        requestPars = requestPars,
        resourceGroupId = resourceGroupId,
        tags = tags,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
