@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin

import com.pulumi.alicloud.mse.EngineNamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Microservice Engine (MSE) Engine Namespace resource.
 * For information about Microservice Engine (MSE) Engine Namespace and how to use it, see [What is Engine Namespace](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createenginenamespace).
 * > **NOTE:** Available in v1.166.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const exampleNetwork = new alicloud.vpc.Network("example", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: exampleNetwork.id,
 *     zoneId: example.then(example => example.zones?.[0]?.id),
 * });
 * const _default = new alicloud.mse.Cluster("default", {
 *     connectionType: "slb",
 *     netType: "privatenet",
 *     vswitchId: exampleSwitch.id,
 *     clusterSpecification: "MSE_SC_1_2_60_c",
 *     clusterVersion: "NACOS_2_0_0",
 *     instanceCount: 1,
 *     pubNetworkFlow: "1",
 *     clusterAliasName: name,
 *     mseVersion: "mse_dev",
 *     clusterType: "Nacos-Ans",
 * });
 * const exampleEngineNamespace = new alicloud.mse.EngineNamespace("example", {
 *     clusterId: _default.id,
 *     namespaceShowName: name,
 *     namespaceId: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.get_zones(available_resource_creation="VSwitch")
 * example_network = alicloud.vpc.Network("example",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=example_network.id,
 *     zone_id=example.zones[0].id)
 * default = alicloud.mse.Cluster("default",
 *     connection_type="slb",
 *     net_type="privatenet",
 *     vswitch_id=example_switch.id,
 *     cluster_specification="MSE_SC_1_2_60_c",
 *     cluster_version="NACOS_2_0_0",
 *     instance_count=1,
 *     pub_network_flow="1",
 *     cluster_alias_name=name,
 *     mse_version="mse_dev",
 *     cluster_type="Nacos-Ans")
 * example_engine_namespace = alicloud.mse.EngineNamespace("example",
 *     cluster_id=default.id,
 *     namespace_show_name=name,
 *     namespace_id=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var exampleNetwork = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = exampleNetwork.Id,
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var @default = new AliCloud.Mse.Cluster("default", new()
 *     {
 *         ConnectionType = "slb",
 *         NetType = "privatenet",
 *         VswitchId = exampleSwitch.Id,
 *         ClusterSpecification = "MSE_SC_1_2_60_c",
 *         ClusterVersion = "NACOS_2_0_0",
 *         InstanceCount = 1,
 *         PubNetworkFlow = "1",
 *         ClusterAliasName = name,
 *         MseVersion = "mse_dev",
 *         ClusterType = "Nacos-Ans",
 *     });
 *     var exampleEngineNamespace = new AliCloud.Mse.EngineNamespace("example", new()
 *     {
 *         ClusterId = @default.Id,
 *         NamespaceShowName = name,
 *         NamespaceId = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mse"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNetwork, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       exampleNetwork.ID(),
 * 			ZoneId:      pulumi.String(example.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mse.NewCluster(ctx, "default", &mse.ClusterArgs{
 * 			ConnectionType:       pulumi.String("slb"),
 * 			NetType:              pulumi.String("privatenet"),
 * 			VswitchId:            exampleSwitch.ID(),
 * 			ClusterSpecification: pulumi.String("MSE_SC_1_2_60_c"),
 * 			ClusterVersion:       pulumi.String("NACOS_2_0_0"),
 * 			InstanceCount:        pulumi.Int(1),
 * 			PubNetworkFlow:       pulumi.String("1"),
 * 			ClusterAliasName:     pulumi.String(name),
 * 			MseVersion:           pulumi.String("mse_dev"),
 * 			ClusterType:          pulumi.String("Nacos-Ans"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mse.NewEngineNamespace(ctx, "example", &mse.EngineNamespaceArgs{
 * 			ClusterId:         _default.ID(),
 * 			NamespaceShowName: pulumi.String(name),
 * 			NamespaceId:       pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.mse.Cluster;
 * import com.pulumi.alicloud.mse.ClusterArgs;
 * import com.pulumi.alicloud.mse.EngineNamespace;
 * import com.pulumi.alicloud.mse.EngineNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var example = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var exampleNetwork = new Network("exampleNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(exampleNetwork.id())
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .connectionType("slb")
 *             .netType("privatenet")
 *             .vswitchId(exampleSwitch.id())
 *             .clusterSpecification("MSE_SC_1_2_60_c")
 *             .clusterVersion("NACOS_2_0_0")
 *             .instanceCount("1")
 *             .pubNetworkFlow("1")
 *             .clusterAliasName(name)
 *             .mseVersion("mse_dev")
 *             .clusterType("Nacos-Ans")
 *             .build());
 *         var exampleEngineNamespace = new EngineNamespace("exampleEngineNamespace", EngineNamespaceArgs.builder()
 *             .clusterId(default_.id())
 *             .namespaceShowName(name)
 *             .namespaceId(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   exampleNetwork:
 *     type: alicloud:vpc:Network
 *     name: example
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *       vpcId: ${exampleNetwork.id}
 *       zoneId: ${example.zones[0].id}
 *   default:
 *     type: alicloud:mse:Cluster
 *     properties:
 *       connectionType: slb
 *       netType: privatenet
 *       vswitchId: ${exampleSwitch.id}
 *       clusterSpecification: MSE_SC_1_2_60_c
 *       clusterVersion: NACOS_2_0_0
 *       instanceCount: '1'
 *       pubNetworkFlow: '1'
 *       clusterAliasName: ${name}
 *       mseVersion: mse_dev
 *       clusterType: Nacos-Ans
 *   exampleEngineNamespace:
 *     type: alicloud:mse:EngineNamespace
 *     name: example
 *     properties:
 *       clusterId: ${default.id}
 *       namespaceShowName: ${name}
 *       namespaceId: ${name}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Microservice Engine (MSE) Engine Namespace can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mse/engineNamespace:EngineNamespace example <cluster_id>:<namespace_id>
 * ```
 * @property acceptLanguage The language type of the returned information. Valid values: `zh`, `en`.
 * @property clusterId The id of the cluster.
 * @property namespaceId The id of Namespace.
 * @property namespaceShowName The name of the Engine Namespace.
 */
public data class EngineNamespaceArgs(
    public val acceptLanguage: Output<String>? = null,
    public val clusterId: Output<String>? = null,
    public val namespaceId: Output<String>? = null,
    public val namespaceShowName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mse.EngineNamespaceArgs> {
    override fun toJava(): com.pulumi.alicloud.mse.EngineNamespaceArgs =
        com.pulumi.alicloud.mse.EngineNamespaceArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .namespaceId(namespaceId?.applyValue({ args0 -> args0 }))
            .namespaceShowName(namespaceShowName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EngineNamespaceArgs].
 */
@PulumiTagMarker
public class EngineNamespaceArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var clusterId: Output<String>? = null

    private var namespaceId: Output<String>? = null

    private var namespaceShowName: Output<String>? = null

    /**
     * @param value The language type of the returned information. Valid values: `zh`, `en`.
     */
    @JvmName("fxbojgyriskejpow")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value The id of the cluster.
     */
    @JvmName("gfgvcqlwglkolmtq")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value The id of Namespace.
     */
    @JvmName("jgmsqvoaclijolch")
    public suspend fun namespaceId(`value`: Output<String>) {
        this.namespaceId = value
    }

    /**
     * @param value The name of the Engine Namespace.
     */
    @JvmName("wvvpvbouiquajlxy")
    public suspend fun namespaceShowName(`value`: Output<String>) {
        this.namespaceShowName = value
    }

    /**
     * @param value The language type of the returned information. Valid values: `zh`, `en`.
     */
    @JvmName("cdabnmsldybwxvtm")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value The id of the cluster.
     */
    @JvmName("gcaspwmrnwggkryb")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The id of Namespace.
     */
    @JvmName("domawgcvsftfhgfm")
    public suspend fun namespaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceId = mapped
    }

    /**
     * @param value The name of the Engine Namespace.
     */
    @JvmName("honvblhmnnvgvvmk")
    public suspend fun namespaceShowName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceShowName = mapped
    }

    internal fun build(): EngineNamespaceArgs = EngineNamespaceArgs(
        acceptLanguage = acceptLanguage,
        clusterId = clusterId,
        namespaceId = namespaceId,
        namespaceShowName = namespaceShowName,
    )
}
