@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin

import com.pulumi.alicloud.mse.kotlin.outputs.GatewaySlbList
import com.pulumi.alicloud.mse.kotlin.outputs.GatewaySlbList.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Gateway].
 */
@PulumiTagMarker
public class GatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayArgs = GatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayArgsBuilder.() -> Unit) {
        val builder = GatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Gateway {
        val builtJavaResource = com.pulumi.alicloud.mse.Gateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Gateway(builtJavaResource)
    }
}

/**
 * Provides a Microservice Engine (MSE) Gateway resource.
 * For information about Microservice Engine (MSE) Gateway and how to use it, see [What is Gateway](https://help.aliyun.com/document_detail/347638.html).
 * > **NOTE:** Available in v1.157.0+.
 * ## Import
 * Microservice Engine (MSE) Gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mse/gateway:Gateway example <id>
 * ```
 */
public class Gateway internal constructor(
    override val javaResource: com.pulumi.alicloud.mse.Gateway,
) : KotlinCustomResource(javaResource, GatewayMapper) {
    /**
     * The backup vswitch id.
     */
    public val backupVswitchId: Output<String>?
        get() = javaResource.backupVswitchId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to delete the SLB purchased on behalf of the gateway at the same time.
     */
    public val deleteSlb: Output<Boolean>?
        get() = javaResource.deleteSlb().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether the enterprise security group type.
     */
    public val enterpriseSecurityGroup: Output<Boolean>?
        get() = javaResource.enterpriseSecurityGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Gateway .
     */
    public val gatewayName: Output<String>?
        get() = javaResource.gatewayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Public network SLB specifications.
     */
    public val internetSlbSpec: Output<String>?
        get() = javaResource.internetSlbSpec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of Gateway Nodes.
     */
    public val replica: Output<Int>
        get() = javaResource.replica().applyValue({ args0 -> args0 })

    /**
     * A list of gateway Slb.
     */
    public val slbLists: Output<List<GatewaySlbList>>
        get() = javaResource.slbLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Private network SLB specifications.
     */
    public val slbSpec: Output<String>?
        get() = javaResource.slbSpec().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gateway Node Specifications. Valid values: `MSE_GTW_2_4_200_c`, `MSE_GTW_4_8_200_c`, `MSE_GTW_8_16_200_c`, `MSE_GTW_16_32_200_c`.
     */
    public val spec: Output<String>
        get() = javaResource.spec().applyValue({ args0 -> args0 })

    /**
     * The status of the gateway.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the vpc.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of the vswitch.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object GatewayMapper : ResourceMapper<Gateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.mse.Gateway::class == javaResource::class

    override fun map(javaResource: Resource): Gateway = Gateway(
        javaResource as
            com.pulumi.alicloud.mse.Gateway,
    )
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gateway].
 */
public suspend fun gateway(name: String, block: suspend GatewayResourceBuilder.() -> Unit): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gateway(name: String): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
