@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin

import com.pulumi.alicloud.mse.GatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Microservice Engine (MSE) Gateway resource.
 * For information about Microservice Engine (MSE) Gateway and how to use it, see [What is Gateway](https://help.aliyun.com/document_detail/347638.html).
 * > **NOTE:** Available in v1.157.0+.
 * ## Import
 * Microservice Engine (MSE) Gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mse/gateway:Gateway example <id>
 * ```
 * @property backupVswitchId The backup vswitch id.
 * @property deleteSlb Whether to delete the SLB purchased on behalf of the gateway at the same time.
 * @property enterpriseSecurityGroup Whether the enterprise security group type.
 * @property gatewayName The name of the Gateway .
 * @property internetSlbSpec Public network SLB specifications.
 * @property replica Number of Gateway Nodes.
 * @property slbSpec Private network SLB specifications.
 * @property spec Gateway Node Specifications. Valid values: `MSE_GTW_2_4_200_c`, `MSE_GTW_4_8_200_c`, `MSE_GTW_8_16_200_c`, `MSE_GTW_16_32_200_c`.
 * @property vpcId The ID of the vpc.
 * @property vswitchId The ID of the vswitch.
 */
public data class GatewayArgs(
    public val backupVswitchId: Output<String>? = null,
    public val deleteSlb: Output<Boolean>? = null,
    public val enterpriseSecurityGroup: Output<Boolean>? = null,
    public val gatewayName: Output<String>? = null,
    public val internetSlbSpec: Output<String>? = null,
    public val replica: Output<Int>? = null,
    public val slbSpec: Output<String>? = null,
    public val spec: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mse.GatewayArgs> {
    override fun toJava(): com.pulumi.alicloud.mse.GatewayArgs =
        com.pulumi.alicloud.mse.GatewayArgs.builder()
            .backupVswitchId(backupVswitchId?.applyValue({ args0 -> args0 }))
            .deleteSlb(deleteSlb?.applyValue({ args0 -> args0 }))
            .enterpriseSecurityGroup(enterpriseSecurityGroup?.applyValue({ args0 -> args0 }))
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 }))
            .internetSlbSpec(internetSlbSpec?.applyValue({ args0 -> args0 }))
            .replica(replica?.applyValue({ args0 -> args0 }))
            .slbSpec(slbSpec?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayArgs].
 */
@PulumiTagMarker
public class GatewayArgsBuilder internal constructor() {
    private var backupVswitchId: Output<String>? = null

    private var deleteSlb: Output<Boolean>? = null

    private var enterpriseSecurityGroup: Output<Boolean>? = null

    private var gatewayName: Output<String>? = null

    private var internetSlbSpec: Output<String>? = null

    private var replica: Output<Int>? = null

    private var slbSpec: Output<String>? = null

    private var spec: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The backup vswitch id.
     */
    @JvmName("gtunihrkcujqydic")
    public suspend fun backupVswitchId(`value`: Output<String>) {
        this.backupVswitchId = value
    }

    /**
     * @param value Whether to delete the SLB purchased on behalf of the gateway at the same time.
     */
    @JvmName("fgtukdnkqsgtihhl")
    public suspend fun deleteSlb(`value`: Output<Boolean>) {
        this.deleteSlb = value
    }

    /**
     * @param value Whether the enterprise security group type.
     */
    @JvmName("vuhaedykqesddlmn")
    public suspend fun enterpriseSecurityGroup(`value`: Output<Boolean>) {
        this.enterpriseSecurityGroup = value
    }

    /**
     * @param value The name of the Gateway .
     */
    @JvmName("orvlslqkqbvsptgu")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value Public network SLB specifications.
     */
    @JvmName("xwwkwwuhryruqliw")
    public suspend fun internetSlbSpec(`value`: Output<String>) {
        this.internetSlbSpec = value
    }

    /**
     * @param value Number of Gateway Nodes.
     */
    @JvmName("uoouoygqeesnlqyy")
    public suspend fun replica(`value`: Output<Int>) {
        this.replica = value
    }

    /**
     * @param value Private network SLB specifications.
     */
    @JvmName("gkmypsghsnkpqotn")
    public suspend fun slbSpec(`value`: Output<String>) {
        this.slbSpec = value
    }

    /**
     * @param value Gateway Node Specifications. Valid values: `MSE_GTW_2_4_200_c`, `MSE_GTW_4_8_200_c`, `MSE_GTW_8_16_200_c`, `MSE_GTW_16_32_200_c`.
     */
    @JvmName("wgiipkaqkvxiicpt")
    public suspend fun spec(`value`: Output<String>) {
        this.spec = value
    }

    /**
     * @param value The ID of the vpc.
     */
    @JvmName("qvaenufpatyltsxh")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the vswitch.
     */
    @JvmName("uypifgohvutctdvf")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The backup vswitch id.
     */
    @JvmName("hkbogsppavrjibnc")
    public suspend fun backupVswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupVswitchId = mapped
    }

    /**
     * @param value Whether to delete the SLB purchased on behalf of the gateway at the same time.
     */
    @JvmName("sbxmovxiftnifghw")
    public suspend fun deleteSlb(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteSlb = mapped
    }

    /**
     * @param value Whether the enterprise security group type.
     */
    @JvmName("yviygjqrjkeowipx")
    public suspend fun enterpriseSecurityGroup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enterpriseSecurityGroup = mapped
    }

    /**
     * @param value The name of the Gateway .
     */
    @JvmName("mxncwwnolyixkaob")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    /**
     * @param value Public network SLB specifications.
     */
    @JvmName("ybuhormauikeqrnf")
    public suspend fun internetSlbSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetSlbSpec = mapped
    }

    /**
     * @param value Number of Gateway Nodes.
     */
    @JvmName("qstesjchahnwlble")
    public suspend fun replica(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replica = mapped
    }

    /**
     * @param value Private network SLB specifications.
     */
    @JvmName("adgmxvwaoytommtj")
    public suspend fun slbSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slbSpec = mapped
    }

    /**
     * @param value Gateway Node Specifications. Valid values: `MSE_GTW_2_4_200_c`, `MSE_GTW_4_8_200_c`, `MSE_GTW_8_16_200_c`, `MSE_GTW_16_32_200_c`.
     */
    @JvmName("nxsysrbalqhdxpiw")
    public suspend fun spec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param value The ID of the vpc.
     */
    @JvmName("fnmsidufkxydshnh")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the vswitch.
     */
    @JvmName("gwgjxvaensheynhv")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): GatewayArgs = GatewayArgs(
        backupVswitchId = backupVswitchId,
        deleteSlb = deleteSlb,
        enterpriseSecurityGroup = enterpriseSecurityGroup,
        gatewayName = gatewayName,
        internetSlbSpec = internetSlbSpec,
        replica = replica,
        slbSpec = slbSpec,
        spec = spec,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
