@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin

import com.pulumi.alicloud.mse.MseFunctions.getClustersPlain
import com.pulumi.alicloud.mse.MseFunctions.getEngineNamespacesPlain
import com.pulumi.alicloud.mse.MseFunctions.getGatewaysPlain
import com.pulumi.alicloud.mse.MseFunctions.getZnodesPlain
import com.pulumi.alicloud.mse.kotlin.inputs.GetClustersPlainArgs
import com.pulumi.alicloud.mse.kotlin.inputs.GetClustersPlainArgsBuilder
import com.pulumi.alicloud.mse.kotlin.inputs.GetEngineNamespacesPlainArgs
import com.pulumi.alicloud.mse.kotlin.inputs.GetEngineNamespacesPlainArgsBuilder
import com.pulumi.alicloud.mse.kotlin.inputs.GetGatewaysPlainArgs
import com.pulumi.alicloud.mse.kotlin.inputs.GetGatewaysPlainArgsBuilder
import com.pulumi.alicloud.mse.kotlin.inputs.GetZnodesPlainArgs
import com.pulumi.alicloud.mse.kotlin.inputs.GetZnodesPlainArgsBuilder
import com.pulumi.alicloud.mse.kotlin.outputs.GetClustersResult
import com.pulumi.alicloud.mse.kotlin.outputs.GetEngineNamespacesResult
import com.pulumi.alicloud.mse.kotlin.outputs.GetGatewaysResult
import com.pulumi.alicloud.mse.kotlin.outputs.GetZnodesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.mse.kotlin.outputs.GetClustersResult.Companion.toKotlin as getClustersResultToKotlin
import com.pulumi.alicloud.mse.kotlin.outputs.GetEngineNamespacesResult.Companion.toKotlin as getEngineNamespacesResultToKotlin
import com.pulumi.alicloud.mse.kotlin.outputs.GetGatewaysResult.Companion.toKotlin as getGatewaysResultToKotlin
import com.pulumi.alicloud.mse.kotlin.outputs.GetZnodesResult.Companion.toKotlin as getZnodesResultToKotlin

public object MseFunctions {
    /**
     * This data source provides a list of MSE Clusters in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in v1.94.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const example = alicloud.mse.getClusters({
     *     ids: ["mse-cn-0d9xxxx"],
     *     status: "INIT_SUCCESS",
     * });
     * export const clusterId = example.then(example => example.clusters?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * example = alicloud.mse.get_clusters(ids=["mse-cn-0d9xxxx"],
     *     status="INIT_SUCCESS")
     * pulumi.export("clusterId", example.clusters[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var example = AliCloud.Mse.GetClusters.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "mse-cn-0d9xxxx",
     *         },
     *         Status = "INIT_SUCCESS",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["clusterId"] = example&#46;Apply(getClustersResult => getClustersResult&#46;Clusters[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mse"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		example, err := mse.GetClusters(ctx, &mse.GetClustersArgs{
     * 			Ids: []string{
     * 				"mse-cn-0d9xxxx",
     * 			},
     * 			Status: pulumi.StringRef("INIT_SUCCESS"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("clusterId", example.Clusters[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mse.MseFunctions;
     * import com.pulumi.alicloud.mse.inputs.GetClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var example = MseFunctions.getClusters(GetClustersArgs.builder()
     *             .ids("mse-cn-0d9xxxx")
     *             .status("INIT_SUCCESS")
     *             .build());
     *         ctx.export("clusterId", example.applyValue(getClustersResult -> getClustersResult.clusters()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   example:
     *     fn::invoke:
     *       Function: alicloud:mse:getClusters
     *       Arguments:
     *         ids:
     *           - mse-cn-0d9xxxx
     *         status: INIT_SUCCESS
     * outputs:
     *   clusterId: ${example.clusters[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusters.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: GetClustersPlainArgs): GetClustersResult =
        getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())

    /**
     * @see [getClusters].
     * @param clusterAliasName The alias name of MSE Cluster.
     * @param enableDetails
     * @param ids A list of MSE Cluster ids.
     * @param nameRegex A regex string to filter the results by the cluster alias name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param requestPars
     * @param status The status of MSE Cluster. Valid: `DESTROY_FAILED`, `DESTROY_ING`, `DESTROY_SUCCESS`, `INIT_FAILED`, `INIT_ING`, `INIT_SUCCESS`, `INIT_TIME_OUT`, `RESTART_FAILED`, `RESTART_ING`, `RESTART_SUCCESS`, `SCALE_FAILED`, `SCALE_ING`, `SCALE_SUCCESS`
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(
        clusterAliasName: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        requestPars: String? = null,
        status: String? = null,
    ): GetClustersResult {
        val argument = GetClustersPlainArgs(
            clusterAliasName = clusterAliasName,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            requestPars = requestPars,
            status = status,
        )
        return getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mse&#46;kotlin&#46;inputs&#46;GetClustersPlainArgs].
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: suspend GetClustersPlainArgsBuilder.() -> Unit): GetClustersResult {
        val builder = GetClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClustersResultToKotlin(getClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Mse Engine Namespaces of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.166.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.mse.getEngineNamespaces({
     *     clusterId: "example_value",
     *     ids: ["example_value"],
     * });
     * export const mseEngineNamespaceId1 = ids.then(ids => ids.namespaces?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.mse.get_engine_namespaces(cluster_id="example_value",
     *     ids=["example_value"])
     * pulumi.export("mseEngineNamespaceId1", ids.namespaces[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Mse.GetEngineNamespaces.Invoke(new()
     *     {
     *         ClusterId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["mseEngineNamespaceId1"] = ids&#46;Apply(getEngineNamespacesResult => getEngineNamespacesResult&#46;Namespaces[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mse"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := mse.GetEngineNamespaces(ctx, &mse.GetEngineNamespacesArgs{
     * 			ClusterId: "example_value",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mseEngineNamespaceId1", ids.Namespaces[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mse.MseFunctions;
     * import com.pulumi.alicloud.mse.inputs.GetEngineNamespacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = MseFunctions.getEngineNamespaces(GetEngineNamespacesArgs.builder()
     *             .clusterId("example_value")
     *             .ids("example_value")
     *             .build());
     *         ctx.export("mseEngineNamespaceId1", ids.applyValue(getEngineNamespacesResult -> getEngineNamespacesResult.namespaces()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:mse:getEngineNamespaces
     *       Arguments:
     *         clusterId: example_value
     *         ids:
     *           - example_value
     * outputs:
     *   mseEngineNamespaceId1: ${ids.namespaces[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEngineNamespaces.
     * @return A collection of values returned by getEngineNamespaces.
     */
    public suspend fun getEngineNamespaces(argument: GetEngineNamespacesPlainArgs): GetEngineNamespacesResult =
        getEngineNamespacesResultToKotlin(getEngineNamespacesPlain(argument.toJava()).await())

    /**
     * @see [getEngineNamespaces].
     * @param acceptLanguage The language type of the returned information. Valid values: `zh`, `en`.
     * @param clusterId The id of the cluster.
     * @param ids A list of Engine Namespace IDs. It is formatted to `<cluster_id>:<namespace_id>`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getEngineNamespaces.
     */
    public suspend fun getEngineNamespaces(
        acceptLanguage: String? = null,
        clusterId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
    ): GetEngineNamespacesResult {
        val argument = GetEngineNamespacesPlainArgs(
            acceptLanguage = acceptLanguage,
            clusterId = clusterId,
            ids = ids,
            outputFile = outputFile,
        )
        return getEngineNamespacesResultToKotlin(getEngineNamespacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEngineNamespaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mse&#46;kotlin&#46;inputs&#46;GetEngineNamespacesPlainArgs].
     * @return A collection of values returned by getEngineNamespaces.
     */
    public suspend fun getEngineNamespaces(argument: suspend GetEngineNamespacesPlainArgsBuilder.() -> Unit): GetEngineNamespacesResult {
        val builder = GetEngineNamespacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEngineNamespacesResultToKotlin(getEngineNamespacesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Mse Gateways of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.157.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.mse.getGateways({
     *     ids: ["example_id"],
     * });
     * export const mseGatewayId1 = ids.then(ids => ids.gateways?.[0]?.id);
     * const nameRegex = alicloud.mse.getGateways({
     *     nameRegex: "^my-Gateway",
     * });
     * export const mseGatewayId2 = nameRegex.then(nameRegex => nameRegex.gateways?.[0]?.id);
     * const status = alicloud.mse.getGateways({
     *     status: "2",
     * });
     * export const mseGatewayId3 = status.then(status => status.gateways?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.mse.get_gateways(ids=["example_id"])
     * pulumi.export("mseGatewayId1", ids.gateways[0].id)
     * name_regex = alicloud.mse.get_gateways(name_regex="^my-Gateway")
     * pulumi.export("mseGatewayId2", name_regex.gateways[0].id)
     * status = alicloud.mse.get_gateways(status="2")
     * pulumi.export("mseGatewayId3", status.gateways[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Mse.GetGateways.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Mse.GetGateways.Invoke(new()
     *     {
     *         NameRegex = "^my-Gateway",
     *     });
     *     var status = AliCloud.Mse.GetGateways.Invoke(new()
     *     {
     *         Status = "2",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["mseGatewayId1"] = ids&#46;Apply(getGatewaysResult => getGatewaysResult&#46;Gateways[0]?.Id),
     *         ["mseGatewayId2"] = nameRegex&#46;Apply(getGatewaysResult => getGatewaysResult&#46;Gateways[0]?.Id),
     *         ["mseGatewayId3"] = status&#46;Apply(getGatewaysResult => getGatewaysResult&#46;Gateways[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mse"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := mse.GetGateways(ctx, &mse.GetGatewaysArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mseGatewayId1", ids.Gateways[0].Id)
     * 		nameRegex, err := mse.GetGateways(ctx, &mse.GetGatewaysArgs{
     * 			NameRegex: pulumi.StringRef("^my-Gateway"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mseGatewayId2", nameRegex.Gateways[0].Id)
     * 		status, err := mse.GetGateways(ctx, &mse.GetGatewaysArgs{
     * 			Status: pulumi.StringRef("2"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mseGatewayId3", status.Gateways[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mse.MseFunctions;
     * import com.pulumi.alicloud.mse.inputs.GetGatewaysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = MseFunctions.getGateways(GetGatewaysArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("mseGatewayId1", ids.applyValue(getGatewaysResult -> getGatewaysResult.gateways()[0].id()));
     *         final var nameRegex = MseFunctions.getGateways(GetGatewaysArgs.builder()
     *             .nameRegex("^my-Gateway")
     *             .build());
     *         ctx.export("mseGatewayId2", nameRegex.applyValue(getGatewaysResult -> getGatewaysResult.gateways()[0].id()));
     *         final var status = MseFunctions.getGateways(GetGatewaysArgs.builder()
     *             .status("2")
     *             .build());
     *         ctx.export("mseGatewayId3", status.applyValue(getGatewaysResult -> getGatewaysResult.gateways()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:mse:getGateways
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:mse:getGateways
     *       Arguments:
     *         nameRegex: ^my-Gateway
     *   status:
     *     fn::invoke:
     *       Function: alicloud:mse:getGateways
     *       Arguments:
     *         status: '2'
     * outputs:
     *   mseGatewayId1: ${ids.gateways[0].id}
     *   mseGatewayId2: ${nameRegex.gateways[0].id}
     *   mseGatewayId3: ${status.gateways[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGateways.
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(argument: GetGatewaysPlainArgs): GetGatewaysResult =
        getGatewaysResultToKotlin(getGatewaysPlain(argument.toJava()).await())

    /**
     * @see [getGateways].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param gatewayName The name of the Gateway.
     * @param ids A list of Gateway IDs.
     * @param nameRegex A regex string to filter results by Gateway name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the gateway. Valid values: `0`, `1`, `2`, `3`, `4`, `6`, `8`, `9`, `10`, `11`, `12`, `13`.
     * @param vpcId The ID of the VPC.
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(
        enableDetails: Boolean? = null,
        gatewayName: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        vpcId: String? = null,
    ): GetGatewaysResult {
        val argument = GetGatewaysPlainArgs(
            enableDetails = enableDetails,
            gatewayName = gatewayName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            vpcId = vpcId,
        )
        return getGatewaysResultToKotlin(getGatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getGateways].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mse&#46;kotlin&#46;inputs&#46;GetGatewaysPlainArgs].
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(argument: suspend GetGatewaysPlainArgsBuilder.() -> Unit): GetGatewaysResult {
        val builder = GetGatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewaysResultToKotlin(getGatewaysPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Mse Znodes of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.162.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.mse.getZnodes({
     *     clusterId: "example_value",
     *     path: "/",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const mseZnodeId1 = ids.then(ids => ids.znodes?.[0]?.id);
     * const nameRegex = alicloud.mse.getZnodes({
     *     path: "/",
     *     clusterId: "example_value",
     *     nameRegex: "^my-Znode",
     * });
     * export const mseZnodeId2 = nameRegex.then(nameRegex => nameRegex.znodes?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.mse.get_znodes(cluster_id="example_value",
     *     path="/",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("mseZnodeId1", ids.znodes[0].id)
     * name_regex = alicloud.mse.get_znodes(path="/",
     *     cluster_id="example_value",
     *     name_regex="^my-Znode")
     * pulumi.export("mseZnodeId2", name_regex.znodes[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Mse.GetZnodes.Invoke(new()
     *     {
     *         ClusterId = "example_value",
     *         Path = "/",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Mse.GetZnodes.Invoke(new()
     *     {
     *         Path = "/",
     *         ClusterId = "example_value",
     *         NameRegex = "^my-Znode",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["mseZnodeId1"] = ids&#46;Apply(getZnodesResult => getZnodesResult&#46;Znodes[0]?.Id),
     *         ["mseZnodeId2"] = nameRegex&#46;Apply(getZnodesResult => getZnodesResult&#46;Znodes[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mse"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := mse.GetZnodes(ctx, &mse.GetZnodesArgs{
     * 			ClusterId: "example_value",
     * 			Path:      "/",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mseZnodeId1", ids.Znodes[0].Id)
     * 		nameRegex, err := mse.GetZnodes(ctx, &mse.GetZnodesArgs{
     * 			Path:      "/",
     * 			ClusterId: "example_value",
     * 			NameRegex: pulumi.StringRef("^my-Znode"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mseZnodeId2", nameRegex.Znodes[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mse.MseFunctions;
     * import com.pulumi.alicloud.mse.inputs.GetZnodesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = MseFunctions.getZnodes(GetZnodesArgs.builder()
     *             .clusterId("example_value")
     *             .path("/")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("mseZnodeId1", ids.applyValue(getZnodesResult -> getZnodesResult.znodes()[0].id()));
     *         final var nameRegex = MseFunctions.getZnodes(GetZnodesArgs.builder()
     *             .path("/")
     *             .clusterId("example_value")
     *             .nameRegex("^my-Znode")
     *             .build());
     *         ctx.export("mseZnodeId2", nameRegex.applyValue(getZnodesResult -> getZnodesResult.znodes()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:mse:getZnodes
     *       Arguments:
     *         clusterId: example_value
     *         path: /
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:mse:getZnodes
     *       Arguments:
     *         path: /
     *         clusterId: example_value
     *         nameRegex: ^my-Znode
     * outputs:
     *   mseZnodeId1: ${ids.znodes[0].id}
     *   mseZnodeId2: ${nameRegex.znodes[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZnodes.
     * @return A collection of values returned by getZnodes.
     */
    public suspend fun getZnodes(argument: GetZnodesPlainArgs): GetZnodesResult =
        getZnodesResultToKotlin(getZnodesPlain(argument.toJava()).await())

    /**
     * @see [getZnodes].
     * @param acceptLanguage The language type of the returned information. Valid values: `zh` or `en`.
     * @param clusterId The ID of the Cluster.
     * @param ids A list of Znode IDs.
     * @param nameRegex A regex string to filter results by Znode name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param path The Node path.
     * @return A collection of values returned by getZnodes.
     */
    public suspend fun getZnodes(
        acceptLanguage: String? = null,
        clusterId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        path: String,
    ): GetZnodesResult {
        val argument = GetZnodesPlainArgs(
            acceptLanguage = acceptLanguage,
            clusterId = clusterId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            path = path,
        )
        return getZnodesResultToKotlin(getZnodesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZnodes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mse&#46;kotlin&#46;inputs&#46;GetZnodesPlainArgs].
     * @return A collection of values returned by getZnodes.
     */
    public suspend fun getZnodes(argument: suspend GetZnodesPlainArgsBuilder.() -> Unit): GetZnodesResult {
        val builder = GetZnodesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZnodesResultToKotlin(getZnodesPlain(builtArgument.toJava()).await())
    }
}
