@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin.inputs

import com.pulumi.alicloud.mse.inputs.GetClustersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusters.
 * @property clusterAliasName The alias name of MSE Cluster.
 * @property enableDetails
 * @property ids A list of MSE Cluster ids.
 * @property nameRegex A regex string to filter the results by the cluster alias name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property requestPars
 * @property status The status of MSE Cluster. Valid: `DESTROY_FAILED`, `DESTROY_ING`, `DESTROY_SUCCESS`, `INIT_FAILED`, `INIT_ING`, `INIT_SUCCESS`, `INIT_TIME_OUT`, `RESTART_FAILED`, `RESTART_ING`, `RESTART_SUCCESS`, `SCALE_FAILED`, `SCALE_ING`, `SCALE_SUCCESS`
 */
public data class GetClustersPlainArgs(
    public val clusterAliasName: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val requestPars: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mse.inputs.GetClustersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mse.inputs.GetClustersPlainArgs =
        com.pulumi.alicloud.mse.inputs.GetClustersPlainArgs.builder()
            .clusterAliasName(clusterAliasName?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .requestPars(requestPars?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClustersPlainArgs].
 */
@PulumiTagMarker
public class GetClustersPlainArgsBuilder internal constructor() {
    private var clusterAliasName: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var requestPars: String? = null

    private var status: String? = null

    /**
     * @param value The alias name of MSE Cluster.
     */
    @JvmName("akxhamctieymmlqt")
    public suspend fun clusterAliasName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clusterAliasName = mapped
    }

    /**
     * @param value
     */
    @JvmName("xaohmdkdnkuysede")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of MSE Cluster ids.
     */
    @JvmName("nqhylelrdxhhndhn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of MSE Cluster ids.
     */
    @JvmName("xsubmkvxaxxmvdqs")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter the results by the cluster alias name.
     */
    @JvmName("lmhhslehfktsnjsu")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hfnchmaarmhmgsrw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ivpierihuyowxxay")
    public suspend fun requestPars(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.requestPars = mapped
    }

    /**
     * @param value The status of MSE Cluster. Valid: `DESTROY_FAILED`, `DESTROY_ING`, `DESTROY_SUCCESS`, `INIT_FAILED`, `INIT_ING`, `INIT_SUCCESS`, `INIT_TIME_OUT`, `RESTART_FAILED`, `RESTART_ING`, `RESTART_SUCCESS`, `SCALE_FAILED`, `SCALE_ING`, `SCALE_SUCCESS`
     */
    @JvmName("iogdrqfabqskcokb")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetClustersPlainArgs = GetClustersPlainArgs(
        clusterAliasName = clusterAliasName,
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        requestPars = requestPars,
        status = status,
    )
}
