@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin.inputs

import com.pulumi.alicloud.mse.inputs.GetEngineNamespacesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEngineNamespaces.
 * @property acceptLanguage The language type of the returned information. Valid values: `zh`, `en`.
 * @property clusterId The id of the cluster.
 * @property ids A list of Engine Namespace IDs. It is formatted to `<cluster_id>:<namespace_id>`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetEngineNamespacesPlainArgs(
    public val acceptLanguage: String? = null,
    public val clusterId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mse.inputs.GetEngineNamespacesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mse.inputs.GetEngineNamespacesPlainArgs =
        com.pulumi.alicloud.mse.inputs.GetEngineNamespacesPlainArgs.builder()
            .acceptLanguage(acceptLanguage?.let({ args0 -> args0 }))
            .clusterId(clusterId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEngineNamespacesPlainArgs].
 */
@PulumiTagMarker
public class GetEngineNamespacesPlainArgsBuilder internal constructor() {
    private var acceptLanguage: String? = null

    private var clusterId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value The language type of the returned information. Valid values: `zh`, `en`.
     */
    @JvmName("goveegbubmkkdjrg")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.acceptLanguage = mapped
    }

    /**
     * @param value The id of the cluster.
     */
    @JvmName("ngxawnoxjcfidjhd")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value A list of Engine Namespace IDs. It is formatted to `<cluster_id>:<namespace_id>`.
     */
    @JvmName("hprugecuujwwqstd")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Engine Namespace IDs. It is formatted to `<cluster_id>:<namespace_id>`.
     */
    @JvmName("acmuvkkhmaftlmbh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wolssypfsdpmwclw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetEngineNamespacesPlainArgs = GetEngineNamespacesPlainArgs(
        acceptLanguage = acceptLanguage,
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        ids = ids,
        outputFile = outputFile,
    )
}
