@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin.inputs

import com.pulumi.alicloud.mse.inputs.GetGatewaysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGateways.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property gatewayName The name of the Gateway.
 * @property ids A list of Gateway IDs.
 * @property nameRegex A regex string to filter results by Gateway name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the gateway. Valid values: `0`, `1`, `2`, `3`, `4`, `6`, `8`, `9`, `10`, `11`, `12`, `13`.
 * @property vpcId The ID of the VPC.
 */
public data class GetGatewaysPlainArgs(
    public val enableDetails: Boolean? = null,
    public val gatewayName: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mse.inputs.GetGatewaysPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mse.inputs.GetGatewaysPlainArgs =
        com.pulumi.alicloud.mse.inputs.GetGatewaysPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .gatewayName(gatewayName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewaysPlainArgs].
 */
@PulumiTagMarker
public class GetGatewaysPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var gatewayName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var vpcId: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("owfewqtjubveemrb")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value The name of the Gateway.
     */
    @JvmName("ycvupebgntnvewhd")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.gatewayName = mapped
    }

    /**
     * @param value A list of Gateway IDs.
     */
    @JvmName("xolfhxmukxgidrln")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Gateway IDs.
     */
    @JvmName("dlcwctuhcaichaxa")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Gateway name.
     */
    @JvmName("olunolpdfayiyodh")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("adnwpyrqtjyeebyh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the gateway. Valid values: `0`, `1`, `2`, `3`, `4`, `6`, `8`, `9`, `10`, `11`, `12`, `13`.
     */
    @JvmName("wjtcqqjseryqeqqf")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("snyvarxwnojvkscd")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetGatewaysPlainArgs = GetGatewaysPlainArgs(
        enableDetails = enableDetails,
        gatewayName = gatewayName,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        vpcId = vpcId,
    )
}
