@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin.inputs

import com.pulumi.alicloud.mse.inputs.GetZnodesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getZnodes.
 * @property acceptLanguage The language type of the returned information. Valid values: `zh` or `en`.
 * @property clusterId The ID of the Cluster.
 * @property ids A list of Znode IDs.
 * @property nameRegex A regex string to filter results by Znode name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property path The Node path.
 */
public data class GetZnodesPlainArgs(
    public val acceptLanguage: String? = null,
    public val clusterId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val path: String,
) : ConvertibleToJava<com.pulumi.alicloud.mse.inputs.GetZnodesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mse.inputs.GetZnodesPlainArgs =
        com.pulumi.alicloud.mse.inputs.GetZnodesPlainArgs.builder()
            .acceptLanguage(acceptLanguage?.let({ args0 -> args0 }))
            .clusterId(clusterId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .path(path.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZnodesPlainArgs].
 */
@PulumiTagMarker
public class GetZnodesPlainArgsBuilder internal constructor() {
    private var acceptLanguage: String? = null

    private var clusterId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var path: String? = null

    /**
     * @param value The language type of the returned information. Valid values: `zh` or `en`.
     */
    @JvmName("bvopioulkccfyagn")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.acceptLanguage = mapped
    }

    /**
     * @param value The ID of the Cluster.
     */
    @JvmName("suxmsketibchgvnk")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value A list of Znode IDs.
     */
    @JvmName("hsidakdetdtxstqx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Znode IDs.
     */
    @JvmName("yaxeaksuexnemevb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Znode name.
     */
    @JvmName("goudfqnmqpkqtvvn")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qqbmgnvqtjqewoft")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Node path.
     */
    @JvmName("bwtdsirqfeiqoxrg")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.path = mapped
    }

    internal fun build(): GetZnodesPlainArgs = GetZnodesPlainArgs(
        acceptLanguage = acceptLanguage,
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        path = path ?: throw PulumiNullFieldException("path"),
    )
}
