@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property associateId The associate id.
 * @property gatewaySlbMode The Mode of the gateway slb.
 * @property gatewaySlbStatus The Status of the gateway slb.
 * @property gmtCreate The creation time of the gateway slb.
 * @property slbId The ID of the gateway slb.
 * @property slbIp The ip of the gateway slb.
 * @property slbPort The port of the gateway slb.
 * @property type The type of the gateway slb.
 */
public data class GatewaySlbList(
    public val associateId: String? = null,
    public val gatewaySlbMode: String? = null,
    public val gatewaySlbStatus: String? = null,
    public val gmtCreate: String? = null,
    public val slbId: String? = null,
    public val slbIp: String? = null,
    public val slbPort: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mse.outputs.GatewaySlbList): GatewaySlbList =
            GatewaySlbList(
                associateId = javaType.associateId().map({ args0 -> args0 }).orElse(null),
                gatewaySlbMode = javaType.gatewaySlbMode().map({ args0 -> args0 }).orElse(null),
                gatewaySlbStatus = javaType.gatewaySlbStatus().map({ args0 -> args0 }).orElse(null),
                gmtCreate = javaType.gmtCreate().map({ args0 -> args0 }).orElse(null),
                slbId = javaType.slbId().map({ args0 -> args0 }).orElse(null),
                slbIp = javaType.slbIp().map({ args0 -> args0 }).orElse(null),
                slbPort = javaType.slbPort().map({ args0 -> args0 }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
            )
    }
}
