@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aclId The id of acl.
 * @property appVersion The version of app.
 * @property clusterId ID of the MSE Cluster.
 * @property clusterName ID of the OOS Executions.
 * @property clusterType The type of MSE Cluster.
 * @property cpu The num of cpu.
 * @property healthStatus The health status of MSE Cluster.
 * @property id ID of the MSE Cluster.
 * @property initCostTime Time-consuming to create.
 * @property instanceCount The count of instance.
 * @property instanceId ID of the MSE Cluster.
 * @property instanceModels The list of instances.
 * @property internetAddress The address of public network.
 * @property internetDomain The domain of public network.
 * @property internetPort The port of public network.
 * @property intranetAddress The address of private network.
 * @property intranetDomain The domain of private network.
 * @property intranetPort The port of private network.
 * @property memoryCapacity The memory size.
 * @property payInfo The type of payment.
 * @property pubNetworkFlow The public network bandwidth.
 * @property status The status of MSE Cluster. Valid: `DESTROY_FAILED`, `DESTROY_ING`, `DESTROY_SUCCESS`, `INIT_FAILED`, `INIT_ING`, `INIT_SUCCESS`, `INIT_TIME_OUT`, `RESTART_FAILED`, `RESTART_ING`, `RESTART_SUCCESS`, `SCALE_FAILED`, `SCALE_ING`, `SCALE_SUCCESS`
 */
public data class GetClustersCluster(
    public val aclId: String,
    public val appVersion: String,
    public val clusterId: String,
    public val clusterName: String,
    public val clusterType: String,
    public val cpu: Int,
    public val healthStatus: String,
    public val id: String,
    public val initCostTime: Int,
    public val instanceCount: Int,
    public val instanceId: String,
    public val instanceModels: List<GetClustersClusterInstanceModel>,
    public val internetAddress: String,
    public val internetDomain: String,
    public val internetPort: String,
    public val intranetAddress: String,
    public val intranetDomain: String,
    public val intranetPort: String,
    public val memoryCapacity: Int,
    public val payInfo: String,
    public val pubNetworkFlow: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mse.outputs.GetClustersCluster): GetClustersCluster = GetClustersCluster(
            aclId = javaType.aclId(),
            appVersion = javaType.appVersion(),
            clusterId = javaType.clusterId(),
            clusterName = javaType.clusterName(),
            clusterType = javaType.clusterType(),
            cpu = javaType.cpu(),
            healthStatus = javaType.healthStatus(),
            id = javaType.id(),
            initCostTime = javaType.initCostTime(),
            instanceCount = javaType.instanceCount(),
            instanceId = javaType.instanceId(),
            instanceModels = javaType.instanceModels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mse.kotlin.outputs.GetClustersClusterInstanceModel.Companion.toKotlin(args0)
                })
            }),
            internetAddress = javaType.internetAddress(),
            internetDomain = javaType.internetDomain(),
            internetPort = javaType.internetPort(),
            intranetAddress = javaType.intranetAddress(),
            intranetDomain = javaType.intranetDomain(),
            intranetPort = javaType.intranetPort(),
            memoryCapacity = javaType.memoryCapacity(),
            payInfo = javaType.payInfo(),
            pubNetworkFlow = javaType.pubNetworkFlow(),
            status = javaType.status(),
        )
    }
}
