@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property configCount The Number of Configuration of the Namespace.
 * @property id The ID of the Engine Namespace. It is formatted to `<cluster_id>:<namespace_id>`.
 * @property namespaceDesc The description of the Namespace.
 * @property namespaceId The id of Namespace.
 * @property namespaceShowName The name of the Namespace.
 * @property quota The Quota of the Namespace.
 * @property serviceCount The number of active services.
 * @property type The type of the Namespace, the value is as follows:
 * - '0': Global Configuration.
 * - '1': default namespace.
 * - '2': Custom Namespace.
 */
public data class GetEngineNamespacesNamespace(
    public val configCount: Int,
    public val id: String,
    public val namespaceDesc: String,
    public val namespaceId: String,
    public val namespaceShowName: String,
    public val quota: Int,
    public val serviceCount: String,
    public val type: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mse.outputs.GetEngineNamespacesNamespace): GetEngineNamespacesNamespace = GetEngineNamespacesNamespace(
            configCount = javaType.configCount(),
            id = javaType.id(),
            namespaceDesc = javaType.namespaceDesc(),
            namespaceId = javaType.namespaceId(),
            namespaceShowName = javaType.namespaceShowName(),
            quota = javaType.quota(),
            serviceCount = javaType.serviceCount(),
            type = javaType.type(),
        )
    }
}
