@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEngineNamespaces.
 * @property acceptLanguage
 * @property clusterId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property namespaces
 * @property outputFile
 */
public data class GetEngineNamespacesResult(
    public val acceptLanguage: String? = null,
    public val clusterId: String,
    public val id: String,
    public val ids: List<String>,
    public val namespaces: List<GetEngineNamespacesNamespace>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mse.outputs.GetEngineNamespacesResult): GetEngineNamespacesResult = GetEngineNamespacesResult(
            acceptLanguage = javaType.acceptLanguage().map({ args0 -> args0 }).orElse(null),
            clusterId = javaType.clusterId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            namespaces = javaType.namespaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mse.kotlin.outputs.GetEngineNamespacesNamespace.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
