@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backupVswitchId The backup vswitch id.
 * @property gatewayName The name of the Gateway.
 * @property gatewayUniqueId Gateway unique identification.
 * @property id The ID of the Gateway.
 * @property paymentType The payment type of the resource.
 * @property replica Number of Gateway Nodes.
 * @property slbLists A list of gateway Slb.
 * @property spec Gateway Node Specifications.
 * @property status The status of the gateway.
 * @property vpcId The ID of the vpc.
 * @property vswitchId The ID of the vswitch.
 */
public data class GetGatewaysGateway(
    public val backupVswitchId: String,
    public val gatewayName: String,
    public val gatewayUniqueId: String,
    public val id: String,
    public val paymentType: String,
    public val replica: String,
    public val slbLists: List<GetGatewaysGatewaySlbList>,
    public val spec: String,
    public val status: String,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mse.outputs.GetGatewaysGateway): GetGatewaysGateway = GetGatewaysGateway(
            backupVswitchId = javaType.backupVswitchId(),
            gatewayName = javaType.gatewayName(),
            gatewayUniqueId = javaType.gatewayUniqueId(),
            id = javaType.id(),
            paymentType = javaType.paymentType(),
            replica = javaType.replica(),
            slbLists = javaType.slbLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mse.kotlin.outputs.GetGatewaysGatewaySlbList.Companion.toKotlin(args0)
                })
            }),
            spec = javaType.spec(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
