@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGateways.
 * @property enableDetails
 * @property gatewayName
 * @property gateways
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property status
 * @property vpcId
 */
public data class GetGatewaysResult(
    public val enableDetails: Boolean? = null,
    public val gatewayName: String? = null,
    public val gateways: List<GetGatewaysGateway>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mse.outputs.GetGatewaysResult): GetGatewaysResult = GetGatewaysResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            gatewayName = javaType.gatewayName().map({ args0 -> args0 }).orElse(null),
            gateways = javaType.gateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mse.kotlin.outputs.GetGatewaysGateway.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
