@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mse.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clusterId The ID of the Cluster.
 * @property data The Node data.
 * @property dir Node list information, the value is as follows:
 * @property id The ID of the Znode. The value formats as `<cluster_id>:<path>`.
 * @property path The Node path.
 * @property znodeName The Node name.
 */
public data class GetZnodesZnode(
    public val clusterId: String,
    public val `data`: String,
    public val dir: Boolean,
    public val id: String,
    public val path: String,
    public val znodeName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mse.outputs.GetZnodesZnode): GetZnodesZnode =
            GetZnodesZnode(
                clusterId = javaType.clusterId(),
                `data` = javaType.`data`(),
                dir = javaType.dir(),
                id = javaType.id(),
                path = javaType.path(),
                znodeName = javaType.znodeName(),
            )
    }
}
