@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessGroup].
 */
@PulumiTagMarker
public class AccessGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessGroupArgs = AccessGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessGroupArgsBuilder.() -> Unit) {
        val builder = AccessGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessGroup {
        val builtJavaResource = com.pulumi.alicloud.nas.AccessGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessGroup(builtJavaResource)
    }
}

/**
 * Provides a NAS Access Group resource. File system Access Group.
 * In NAS, the permission group acts as a whitelist that allows you to restrict file system access. You can allow specified IP addresses or CIDR blocks to access the file system, and assign different levels of access permission to different IP addresses or CIDR blocks by adding rules to the permission group.
 * For information about NAS Access Group and how to use it, see [What is NAS Access Group](https://www.alibabacloud.com/help/en/nas/developer-reference/api-nas-2017-06-26-createaccessgroup)
 * > **NOTE:** Available since v1.33.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = new alicloud.nas.AccessGroup("foo", {
 *     accessGroupName: "terraform-example",
 *     accessGroupType: "Vpc",
 *     description: "terraform-example",
 *     fileSystemType: "extreme",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.nas.AccessGroup("foo",
 *     access_group_name="terraform-example",
 *     access_group_type="Vpc",
 *     description="terraform-example",
 *     file_system_type="extreme")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new AliCloud.Nas.AccessGroup("foo", new()
 *     {
 *         AccessGroupName = "terraform-example",
 *         AccessGroupType = "Vpc",
 *         Description = "terraform-example",
 *         FileSystemType = "extreme",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := nas.NewAccessGroup(ctx, "foo", &nas.AccessGroupArgs{
 * 			AccessGroupName: pulumi.String("terraform-example"),
 * 			AccessGroupType: pulumi.String("Vpc"),
 * 			Description:     pulumi.String("terraform-example"),
 * 			FileSystemType:  pulumi.String("extreme"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.AccessGroup;
 * import com.pulumi.alicloud.nas.AccessGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new AccessGroup("foo", AccessGroupArgs.builder()
 *             .accessGroupName("terraform-example")
 *             .accessGroupType("Vpc")
 *             .description("terraform-example")
 *             .fileSystemType("extreme")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:nas:AccessGroup
 *     properties:
 *       accessGroupName: terraform-example
 *       accessGroupType: Vpc
 *       description: terraform-example
 *       fileSystemType: extreme
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NAS Access Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/accessGroup:AccessGroup example <access_group_name>:<file_system_type>
 * ```
 */
public class AccessGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.nas.AccessGroup,
) : KotlinCustomResource(javaResource, AccessGroupMapper) {
    /**
     * The name of the permission group.
     */
    public val accessGroupName: Output<String>
        get() = javaResource.accessGroupName().applyValue({ args0 -> args0 })

    /**
     * Permission group types, including Vpc.
     */
    public val accessGroupType: Output<String>
        get() = javaResource.accessGroupType().applyValue({ args0 -> args0 })

    /**
     * Creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Permission group description information.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * File system type. Value:
     * - standard (default): Universal NAS
     * - extreme: extreme NAS
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val fileSystemType: Output<String>?
        get() = javaResource.fileSystemType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * . Field 'name' has been deprecated from provider version 1.218.0. New field 'access_group_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.218.0. New field 'access_group_name'
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * . Field 'type' has been deprecated from provider version 1.218.0. New field 'access_group_type' instead.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated since provider version 1.218.0. New field 'access_group_type'
      instead.
  """,
    )
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccessGroupMapper : ResourceMapper<AccessGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nas.AccessGroup::class == javaResource::class

    override fun map(javaResource: Resource): AccessGroup = AccessGroup(
        javaResource as
            com.pulumi.alicloud.nas.AccessGroup,
    )
}

/**
 * @see [AccessGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessGroup].
 */
public suspend fun accessGroup(name: String, block: suspend AccessGroupResourceBuilder.() -> Unit): AccessGroup {
    val builder = AccessGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessGroup(name: String): AccessGroup {
    val builder = AccessGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
