@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.alicloud.nas.AccessGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a NAS Access Group resource. File system Access Group.
 * In NAS, the permission group acts as a whitelist that allows you to restrict file system access. You can allow specified IP addresses or CIDR blocks to access the file system, and assign different levels of access permission to different IP addresses or CIDR blocks by adding rules to the permission group.
 * For information about NAS Access Group and how to use it, see [What is NAS Access Group](https://www.alibabacloud.com/help/en/nas/developer-reference/api-nas-2017-06-26-createaccessgroup)
 * > **NOTE:** Available since v1.33.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = new alicloud.nas.AccessGroup("foo", {
 *     accessGroupName: "terraform-example",
 *     accessGroupType: "Vpc",
 *     description: "terraform-example",
 *     fileSystemType: "extreme",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.nas.AccessGroup("foo",
 *     access_group_name="terraform-example",
 *     access_group_type="Vpc",
 *     description="terraform-example",
 *     file_system_type="extreme")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new AliCloud.Nas.AccessGroup("foo", new()
 *     {
 *         AccessGroupName = "terraform-example",
 *         AccessGroupType = "Vpc",
 *         Description = "terraform-example",
 *         FileSystemType = "extreme",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := nas.NewAccessGroup(ctx, "foo", &nas.AccessGroupArgs{
 * 			AccessGroupName: pulumi.String("terraform-example"),
 * 			AccessGroupType: pulumi.String("Vpc"),
 * 			Description:     pulumi.String("terraform-example"),
 * 			FileSystemType:  pulumi.String("extreme"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.AccessGroup;
 * import com.pulumi.alicloud.nas.AccessGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new AccessGroup("foo", AccessGroupArgs.builder()
 *             .accessGroupName("terraform-example")
 *             .accessGroupType("Vpc")
 *             .description("terraform-example")
 *             .fileSystemType("extreme")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:nas:AccessGroup
 *     properties:
 *       accessGroupName: terraform-example
 *       accessGroupType: Vpc
 *       description: terraform-example
 *       fileSystemType: extreme
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NAS Access Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/accessGroup:AccessGroup example <access_group_name>:<file_system_type>
 * ```
 * @property accessGroupName The name of the permission group.
 * @property accessGroupType Permission group types, including Vpc.
 * @property description Permission group description information.
 * @property fileSystemType File system type. Value:
 * - standard (default): Universal NAS
 * - extreme: extreme NAS
 * The following arguments will be discarded. Please use new fields as soon as possible:
 * @property name . Field 'name' has been deprecated from provider version 1.218.0. New field 'access_group_name' instead.
 * @property type . Field 'type' has been deprecated from provider version 1.218.0. New field 'access_group_type' instead.
 */
public data class AccessGroupArgs(
    public val accessGroupName: Output<String>? = null,
    public val accessGroupType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val fileSystemType: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.218.0. New field 'access_group_name'
      instead.
  """,
    )
    public val name: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'type' has been deprecated since provider version 1.218.0. New field 'access_group_type'
      instead.
  """,
    )
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.AccessGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.AccessGroupArgs =
        com.pulumi.alicloud.nas.AccessGroupArgs.builder()
            .accessGroupName(accessGroupName?.applyValue({ args0 -> args0 }))
            .accessGroupType(accessGroupType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fileSystemType(fileSystemType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessGroupArgs].
 */
@PulumiTagMarker
public class AccessGroupArgsBuilder internal constructor() {
    private var accessGroupName: Output<String>? = null

    private var accessGroupType: Output<String>? = null

    private var description: Output<String>? = null

    private var fileSystemType: Output<String>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the permission group.
     */
    @JvmName("ickqftrgdeognqwm")
    public suspend fun accessGroupName(`value`: Output<String>) {
        this.accessGroupName = value
    }

    /**
     * @param value Permission group types, including Vpc.
     */
    @JvmName("yilgrpicndrovwet")
    public suspend fun accessGroupType(`value`: Output<String>) {
        this.accessGroupType = value
    }

    /**
     * @param value Permission group description information.
     */
    @JvmName("nnftkxughcexxxdg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value File system type. Value:
     * - standard (default): Universal NAS
     * - extreme: extreme NAS
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("fegtjduojhfjftvq")
    public suspend fun fileSystemType(`value`: Output<String>) {
        this.fileSystemType = value
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.218.0. New field 'access_group_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.218.0. New field 'access_group_name'
      instead.
  """,
    )
    @JvmName("ccuxegwalokhwldk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value . Field 'type' has been deprecated from provider version 1.218.0. New field 'access_group_type' instead.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated since provider version 1.218.0. New field 'access_group_type'
      instead.
  """,
    )
    @JvmName("yfljnlgsymuvyahu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the permission group.
     */
    @JvmName("upexdmhmbnduuovs")
    public suspend fun accessGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessGroupName = mapped
    }

    /**
     * @param value Permission group types, including Vpc.
     */
    @JvmName("kkoqwfbxukfrbcnj")
    public suspend fun accessGroupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessGroupType = mapped
    }

    /**
     * @param value Permission group description information.
     */
    @JvmName("eoeasmwhqbrfkdjx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value File system type. Value:
     * - standard (default): Universal NAS
     * - extreme: extreme NAS
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("iqwjodhseydelute")
    public suspend fun fileSystemType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemType = mapped
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.218.0. New field 'access_group_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.218.0. New field 'access_group_name'
      instead.
  """,
    )
    @JvmName("qrcbneiijjwgkfbi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value . Field 'type' has been deprecated from provider version 1.218.0. New field 'access_group_type' instead.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated since provider version 1.218.0. New field 'access_group_type'
      instead.
  """,
    )
    @JvmName("oygullmtjgkcnhyh")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AccessGroupArgs = AccessGroupArgs(
        accessGroupName = accessGroupName,
        accessGroupType = accessGroupType,
        description = description,
        fileSystemType = fileSystemType,
        name = name,
        type = type,
    )
}
