@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.alicloud.nas.kotlin.outputs.AccessPointPosixUser
import com.pulumi.alicloud.nas.kotlin.outputs.AccessPointRootPathPermission
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.alicloud.nas.kotlin.outputs.AccessPointPosixUser.Companion.toKotlin as accessPointPosixUserToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.AccessPointRootPathPermission.Companion.toKotlin as accessPointRootPathPermissionToKotlin

/**
 * Builder for [AccessPoint].
 */
@PulumiTagMarker
public class AccessPointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessPointArgs = AccessPointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessPointArgsBuilder.() -> Unit) {
        val builder = AccessPointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessPoint {
        val builtJavaResource = com.pulumi.alicloud.nas.AccessPoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessPoint(builtJavaResource)
    }
}

/**
 * Provides a NAS Access Point resource.
 * For information about NAS Access Point and how to use it, see [What is Access Point](https://www.alibabacloud.com/help/zh/nas/developer-reference/api-nas-2017-06-26-createaccesspoint).
 * > **NOTE:** Available since v1.224.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const regionId = config.get("regionId") || "cn-hangzhou";
 * const azone = config.get("azone") || "cn-hangzhou-g";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultkyVC70 = new alicloud.vpc.Network("defaultkyVC70", {
 *     cidrBlock: "172.16.0.0/12",
 *     description: "接入点测试noRootDirectory",
 * });
 * const defaultoZAPmO = new alicloud.vpc.Switch("defaultoZAPmO", {
 *     vpcId: defaultkyVC70.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     cidrBlock: "172.16.0.0/24",
 * });
 * const defaultBbc7ev = new alicloud.nas.AccessGroup("defaultBbc7ev", {
 *     accessGroupType: "Vpc",
 *     accessGroupName: name,
 *     fileSystemType: "standard",
 * });
 * const defaultVtUpDh = new alicloud.nas.FileSystem("defaultVtUpDh", {
 *     storageType: "Performance",
 *     zoneId: azone,
 *     encryptType: 0,
 *     protocolType: "NFS",
 *     fileSystemType: "standard",
 *     description: "AccessPointnoRootDirectory",
 * });
 * const defaultAccessPoint = new alicloud.nas.AccessPoint("default", {
 *     vpcId: defaultkyVC70.id,
 *     accessGroup: defaultBbc7ev.accessGroupName,
 *     vswitchId: defaultoZAPmO.id,
 *     fileSystemId: defaultVtUpDh.id,
 *     accessPointName: name,
 *     posixUser: {
 *         posixGroupId: 123,
 *         posixUserId: 123,
 *     },
 *     rootPathPermission: {
 *         ownerGroupId: 1,
 *         ownerUserId: 1,
 *         permission: "0777",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * region_id = config.get("regionId")
 * if region_id is None:
 *     region_id = "cn-hangzhou"
 * azone = config.get("azone")
 * if azone is None:
 *     azone = "cn-hangzhou-g"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * defaultky_vc70 = alicloud.vpc.Network("defaultkyVC70",
 *     cidr_block="172.16.0.0/12",
 *     description="接入点测试noRootDirectory")
 * defaulto_za_pm_o = alicloud.vpc.Switch("defaultoZAPmO",
 *     vpc_id=defaultky_vc70.id,
 *     zone_id=default.zones[0].id,
 *     cidr_block="172.16.0.0/24")
 * default_bbc7ev = alicloud.nas.AccessGroup("defaultBbc7ev",
 *     access_group_type="Vpc",
 *     access_group_name=name,
 *     file_system_type="standard")
 * default_vt_up_dh = alicloud.nas.FileSystem("defaultVtUpDh",
 *     storage_type="Performance",
 *     zone_id=azone,
 *     encrypt_type=0,
 *     protocol_type="NFS",
 *     file_system_type="standard",
 *     description="AccessPointnoRootDirectory")
 * default_access_point = alicloud.nas.AccessPoint("default",
 *     vpc_id=defaultky_vc70.id,
 *     access_group=default_bbc7ev.access_group_name,
 *     vswitch_id=defaulto_za_pm_o.id,
 *     file_system_id=default_vt_up_dh.id,
 *     access_point_name=name,
 *     posix_user={
 *         "posix_group_id": 123,
 *         "posix_user_id": 123,
 *     },
 *     root_path_permission={
 *         "owner_group_id": 1,
 *         "owner_user_id": 1,
 *         "permission": "0777",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var regionId = config.Get("regionId") ?? "cn-hangzhou";
 *     var azone = config.Get("azone") ?? "cn-hangzhou-g";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultkyVC70 = new AliCloud.Vpc.Network("defaultkyVC70", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *         Description = "接入点测试noRootDirectory",
 *     });
 *     var defaultoZAPmO = new AliCloud.Vpc.Switch("defaultoZAPmO", new()
 *     {
 *         VpcId = defaultkyVC70.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         CidrBlock = "172.16.0.0/24",
 *     });
 *     var defaultBbc7ev = new AliCloud.Nas.AccessGroup("defaultBbc7ev", new()
 *     {
 *         AccessGroupType = "Vpc",
 *         AccessGroupName = name,
 *         FileSystemType = "standard",
 *     });
 *     var defaultVtUpDh = new AliCloud.Nas.FileSystem("defaultVtUpDh", new()
 *     {
 *         StorageType = "Performance",
 *         ZoneId = azone,
 *         EncryptType = 0,
 *         ProtocolType = "NFS",
 *         FileSystemType = "standard",
 *         Description = "AccessPointnoRootDirectory",
 *     });
 *     var defaultAccessPoint = new AliCloud.Nas.AccessPoint("default", new()
 *     {
 *         VpcId = defaultkyVC70.Id,
 *         AccessGroup = defaultBbc7ev.AccessGroupName,
 *         VswitchId = defaultoZAPmO.Id,
 *         FileSystemId = defaultVtUpDh.Id,
 *         AccessPointName = name,
 *         PosixUser = new AliCloud.Nas.Inputs.AccessPointPosixUserArgs
 *         {
 *             PosixGroupId = 123,
 *             PosixUserId = 123,
 *         },
 *         RootPathPermission = new AliCloud.Nas.Inputs.AccessPointRootPathPermissionArgs
 *         {
 *             OwnerGroupId = 1,
 *             OwnerUserId = 1,
 *             Permission = "0777",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		regionId := "cn-hangzhou"
 * 		if param := cfg.Get("regionId"); param != "" {
 * 			regionId = param
 * 		}
 * 		azone := "cn-hangzhou-g"
 * 		if param := cfg.Get("azone"); param != "" {
 * 			azone = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultkyVC70, err := vpc.NewNetwork(ctx, "defaultkyVC70", &vpc.NetworkArgs{
 * 			CidrBlock:   pulumi.String("172.16.0.0/12"),
 * 			Description: pulumi.String("接入点测试noRootDirectory"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultoZAPmO, err := vpc.NewSwitch(ctx, "defaultoZAPmO", &vpc.SwitchArgs{
 * 			VpcId:     defaultkyVC70.ID(),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 			CidrBlock: pulumi.String("172.16.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBbc7ev, err := nas.NewAccessGroup(ctx, "defaultBbc7ev", &nas.AccessGroupArgs{
 * 			AccessGroupType: pulumi.String("Vpc"),
 * 			AccessGroupName: pulumi.String(name),
 * 			FileSystemType:  pulumi.String("standard"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVtUpDh, err := nas.NewFileSystem(ctx, "defaultVtUpDh", &nas.FileSystemArgs{
 * 			StorageType:    pulumi.String("Performance"),
 * 			ZoneId:         pulumi.String(azone),
 * 			EncryptType:    pulumi.Int(0),
 * 			ProtocolType:   pulumi.String("NFS"),
 * 			FileSystemType: pulumi.String("standard"),
 * 			Description:    pulumi.String("AccessPointnoRootDirectory"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewAccessPoint(ctx, "default", &nas.AccessPointArgs{
 * 			VpcId:           defaultkyVC70.ID(),
 * 			AccessGroup:     defaultBbc7ev.AccessGroupName,
 * 			VswitchId:       defaultoZAPmO.ID(),
 * 			FileSystemId:    defaultVtUpDh.ID(),
 * 			AccessPointName: pulumi.String(name),
 * 			PosixUser: &nas.AccessPointPosixUserArgs{
 * 				PosixGroupId: pulumi.Int(123),
 * 				PosixUserId:  pulumi.Int(123),
 * 			},
 * 			RootPathPermission: &nas.AccessPointRootPathPermissionArgs{
 * 				OwnerGroupId: pulumi.Int(1),
 * 				OwnerUserId:  pulumi.Int(1),
 * 				Permission:   pulumi.String("0777"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.nas.AccessGroup;
 * import com.pulumi.alicloud.nas.AccessGroupArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.nas.AccessPoint;
 * import com.pulumi.alicloud.nas.AccessPointArgs;
 * import com.pulumi.alicloud.nas.inputs.AccessPointPosixUserArgs;
 * import com.pulumi.alicloud.nas.inputs.AccessPointRootPathPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var regionId = config.get("regionId").orElse("cn-hangzhou");
 *         final var azone = config.get("azone").orElse("cn-hangzhou-g");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultkyVC70 = new Network("defaultkyVC70", NetworkArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .description("接入点测试noRootDirectory")
 *             .build());
 *         var defaultoZAPmO = new Switch("defaultoZAPmO", SwitchArgs.builder()
 *             .vpcId(defaultkyVC70.id())
 *             .zoneId(default_.zones()[0].id())
 *             .cidrBlock("172.16.0.0/24")
 *             .build());
 *         var defaultBbc7ev = new AccessGroup("defaultBbc7ev", AccessGroupArgs.builder()
 *             .accessGroupType("Vpc")
 *             .accessGroupName(name)
 *             .fileSystemType("standard")
 *             .build());
 *         var defaultVtUpDh = new FileSystem("defaultVtUpDh", FileSystemArgs.builder()
 *             .storageType("Performance")
 *             .zoneId(azone)
 *             .encryptType("0")
 *             .protocolType("NFS")
 *             .fileSystemType("standard")
 *             .description("AccessPointnoRootDirectory")
 *             .build());
 *         var defaultAccessPoint = new AccessPoint("defaultAccessPoint", AccessPointArgs.builder()
 *             .vpcId(defaultkyVC70.id())
 *             .accessGroup(defaultBbc7ev.accessGroupName())
 *             .vswitchId(defaultoZAPmO.id())
 *             .fileSystemId(defaultVtUpDh.id())
 *             .accessPointName(name)
 *             .posixUser(AccessPointPosixUserArgs.builder()
 *                 .posixGroupId("123")
 *                 .posixUserId("123")
 *                 .build())
 *             .rootPathPermission(AccessPointRootPathPermissionArgs.builder()
 *                 .ownerGroupId("1")
 *                 .ownerUserId("1")
 *                 .permission("0777")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   regionId:
 *     type: string
 *     default: cn-hangzhou
 *   azone:
 *     type: string
 *     default: cn-hangzhou-g
 * resources:
 *   defaultkyVC70:
 *     type: alicloud:vpc:Network
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *       description: 接入点测试noRootDirectory
 *   defaultoZAPmO:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${defaultkyVC70.id}
 *       zoneId: ${default.zones[0].id}
 *       cidrBlock: 172.16.0.0/24
 *   defaultBbc7ev:
 *     type: alicloud:nas:AccessGroup
 *     properties:
 *       accessGroupType: Vpc
 *       accessGroupName: ${name}
 *       fileSystemType: standard
 *   defaultVtUpDh:
 *     type: alicloud:nas:FileSystem
 *     properties:
 *       storageType: Performance
 *       zoneId: ${azone}
 *       encryptType: '0'
 *       protocolType: NFS
 *       fileSystemType: standard
 *       description: AccessPointnoRootDirectory
 *   defaultAccessPoint:
 *     type: alicloud:nas:AccessPoint
 *     name: default
 *     properties:
 *       vpcId: ${defaultkyVC70.id}
 *       accessGroup: ${defaultBbc7ev.accessGroupName}
 *       vswitchId: ${defaultoZAPmO.id}
 *       fileSystemId: ${defaultVtUpDh.id}
 *       accessPointName: ${name}
 *       posixUser:
 *         posixGroupId: '123'
 *         posixUserId: '123'
 *       rootPathPermission:
 *         ownerGroupId: '1'
 *         ownerUserId: '1'
 *         permission: '0777'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NAS Access Point can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/accessPoint:AccessPoint example <file_system_id>:<access_point_id>
 * ```
 */
public class AccessPoint internal constructor(
    override val javaResource: com.pulumi.alicloud.nas.AccessPoint,
) : KotlinCustomResource(javaResource, AccessPointMapper) {
    /**
     * The permission group name.
     */
    public val accessGroup: Output<String>
        get() = javaResource.accessGroup().applyValue({ args0 -> args0 })

    /**
     * Access point ID.
     */
    public val accessPointId: Output<String>
        get() = javaResource.accessPointId().applyValue({ args0 -> args0 })

    /**
     * The Access Point Name.
     */
    public val accessPointName: Output<String>?
        get() = javaResource.accessPointName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Whether to enable the RAM policy.
     */
    public val enabledRam: Output<Boolean>?
        get() = javaResource.enabledRam().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the file system.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * The Posix user. See `posix_user` below.
     */
    public val posixUser: Output<AccessPointPosixUser>
        get() = javaResource.posixUser().applyValue({ args0 ->
            args0.let({ args0 ->
                accessPointPosixUserToKotlin(args0)
            })
        })

    /**
     * The root directory.
     */
    public val rootPath: Output<String>
        get() = javaResource.rootPath().applyValue({ args0 -> args0 })

    /**
     * Root permissions. See `root_path_permission` below.
     */
    public val rootPathPermission: Output<AccessPointRootPathPermission>
        get() = javaResource.rootPathPermission().applyValue({ args0 ->
            args0.let({ args0 ->
                accessPointRootPathPermissionToKotlin(args0)
            })
        })

    /**
     * Current access point state.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The vSwitch ID.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object AccessPointMapper : ResourceMapper<AccessPoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nas.AccessPoint::class == javaResource::class

    override fun map(javaResource: Resource): AccessPoint = AccessPoint(
        javaResource as
            com.pulumi.alicloud.nas.AccessPoint,
    )
}

/**
 * @see [AccessPoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessPoint].
 */
public suspend fun accessPoint(name: String, block: suspend AccessPointResourceBuilder.() -> Unit): AccessPoint {
    val builder = AccessPointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessPoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessPoint(name: String): AccessPoint {
    val builder = AccessPointResourceBuilder()
    builder.name(name)
    return builder.build()
}
