@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.alicloud.nas.AccessPointArgs.builder
import com.pulumi.alicloud.nas.kotlin.inputs.AccessPointPosixUserArgs
import com.pulumi.alicloud.nas.kotlin.inputs.AccessPointPosixUserArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.AccessPointRootPathPermissionArgs
import com.pulumi.alicloud.nas.kotlin.inputs.AccessPointRootPathPermissionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a NAS Access Point resource.
 * For information about NAS Access Point and how to use it, see [What is Access Point](https://www.alibabacloud.com/help/zh/nas/developer-reference/api-nas-2017-06-26-createaccesspoint).
 * > **NOTE:** Available since v1.224.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const regionId = config.get("regionId") || "cn-hangzhou";
 * const azone = config.get("azone") || "cn-hangzhou-g";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultkyVC70 = new alicloud.vpc.Network("defaultkyVC70", {
 *     cidrBlock: "172.16.0.0/12",
 *     description: "接入点测试noRootDirectory",
 * });
 * const defaultoZAPmO = new alicloud.vpc.Switch("defaultoZAPmO", {
 *     vpcId: defaultkyVC70.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     cidrBlock: "172.16.0.0/24",
 * });
 * const defaultBbc7ev = new alicloud.nas.AccessGroup("defaultBbc7ev", {
 *     accessGroupType: "Vpc",
 *     accessGroupName: name,
 *     fileSystemType: "standard",
 * });
 * const defaultVtUpDh = new alicloud.nas.FileSystem("defaultVtUpDh", {
 *     storageType: "Performance",
 *     zoneId: azone,
 *     encryptType: 0,
 *     protocolType: "NFS",
 *     fileSystemType: "standard",
 *     description: "AccessPointnoRootDirectory",
 * });
 * const defaultAccessPoint = new alicloud.nas.AccessPoint("default", {
 *     vpcId: defaultkyVC70.id,
 *     accessGroup: defaultBbc7ev.accessGroupName,
 *     vswitchId: defaultoZAPmO.id,
 *     fileSystemId: defaultVtUpDh.id,
 *     accessPointName: name,
 *     posixUser: {
 *         posixGroupId: 123,
 *         posixUserId: 123,
 *     },
 *     rootPathPermission: {
 *         ownerGroupId: 1,
 *         ownerUserId: 1,
 *         permission: "0777",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * region_id = config.get("regionId")
 * if region_id is None:
 *     region_id = "cn-hangzhou"
 * azone = config.get("azone")
 * if azone is None:
 *     azone = "cn-hangzhou-g"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * defaultky_vc70 = alicloud.vpc.Network("defaultkyVC70",
 *     cidr_block="172.16.0.0/12",
 *     description="接入点测试noRootDirectory")
 * defaulto_za_pm_o = alicloud.vpc.Switch("defaultoZAPmO",
 *     vpc_id=defaultky_vc70.id,
 *     zone_id=default.zones[0].id,
 *     cidr_block="172.16.0.0/24")
 * default_bbc7ev = alicloud.nas.AccessGroup("defaultBbc7ev",
 *     access_group_type="Vpc",
 *     access_group_name=name,
 *     file_system_type="standard")
 * default_vt_up_dh = alicloud.nas.FileSystem("defaultVtUpDh",
 *     storage_type="Performance",
 *     zone_id=azone,
 *     encrypt_type=0,
 *     protocol_type="NFS",
 *     file_system_type="standard",
 *     description="AccessPointnoRootDirectory")
 * default_access_point = alicloud.nas.AccessPoint("default",
 *     vpc_id=defaultky_vc70.id,
 *     access_group=default_bbc7ev.access_group_name,
 *     vswitch_id=defaulto_za_pm_o.id,
 *     file_system_id=default_vt_up_dh.id,
 *     access_point_name=name,
 *     posix_user={
 *         "posix_group_id": 123,
 *         "posix_user_id": 123,
 *     },
 *     root_path_permission={
 *         "owner_group_id": 1,
 *         "owner_user_id": 1,
 *         "permission": "0777",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var regionId = config.Get("regionId") ?? "cn-hangzhou";
 *     var azone = config.Get("azone") ?? "cn-hangzhou-g";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultkyVC70 = new AliCloud.Vpc.Network("defaultkyVC70", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *         Description = "接入点测试noRootDirectory",
 *     });
 *     var defaultoZAPmO = new AliCloud.Vpc.Switch("defaultoZAPmO", new()
 *     {
 *         VpcId = defaultkyVC70.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         CidrBlock = "172.16.0.0/24",
 *     });
 *     var defaultBbc7ev = new AliCloud.Nas.AccessGroup("defaultBbc7ev", new()
 *     {
 *         AccessGroupType = "Vpc",
 *         AccessGroupName = name,
 *         FileSystemType = "standard",
 *     });
 *     var defaultVtUpDh = new AliCloud.Nas.FileSystem("defaultVtUpDh", new()
 *     {
 *         StorageType = "Performance",
 *         ZoneId = azone,
 *         EncryptType = 0,
 *         ProtocolType = "NFS",
 *         FileSystemType = "standard",
 *         Description = "AccessPointnoRootDirectory",
 *     });
 *     var defaultAccessPoint = new AliCloud.Nas.AccessPoint("default", new()
 *     {
 *         VpcId = defaultkyVC70.Id,
 *         AccessGroup = defaultBbc7ev.AccessGroupName,
 *         VswitchId = defaultoZAPmO.Id,
 *         FileSystemId = defaultVtUpDh.Id,
 *         AccessPointName = name,
 *         PosixUser = new AliCloud.Nas.Inputs.AccessPointPosixUserArgs
 *         {
 *             PosixGroupId = 123,
 *             PosixUserId = 123,
 *         },
 *         RootPathPermission = new AliCloud.Nas.Inputs.AccessPointRootPathPermissionArgs
 *         {
 *             OwnerGroupId = 1,
 *             OwnerUserId = 1,
 *             Permission = "0777",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		regionId := "cn-hangzhou"
 * 		if param := cfg.Get("regionId"); param != "" {
 * 			regionId = param
 * 		}
 * 		azone := "cn-hangzhou-g"
 * 		if param := cfg.Get("azone"); param != "" {
 * 			azone = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultkyVC70, err := vpc.NewNetwork(ctx, "defaultkyVC70", &vpc.NetworkArgs{
 * 			CidrBlock:   pulumi.String("172.16.0.0/12"),
 * 			Description: pulumi.String("接入点测试noRootDirectory"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultoZAPmO, err := vpc.NewSwitch(ctx, "defaultoZAPmO", &vpc.SwitchArgs{
 * 			VpcId:     defaultkyVC70.ID(),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 			CidrBlock: pulumi.String("172.16.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBbc7ev, err := nas.NewAccessGroup(ctx, "defaultBbc7ev", &nas.AccessGroupArgs{
 * 			AccessGroupType: pulumi.String("Vpc"),
 * 			AccessGroupName: pulumi.String(name),
 * 			FileSystemType:  pulumi.String("standard"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVtUpDh, err := nas.NewFileSystem(ctx, "defaultVtUpDh", &nas.FileSystemArgs{
 * 			StorageType:    pulumi.String("Performance"),
 * 			ZoneId:         pulumi.String(azone),
 * 			EncryptType:    pulumi.Int(0),
 * 			ProtocolType:   pulumi.String("NFS"),
 * 			FileSystemType: pulumi.String("standard"),
 * 			Description:    pulumi.String("AccessPointnoRootDirectory"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewAccessPoint(ctx, "default", &nas.AccessPointArgs{
 * 			VpcId:           defaultkyVC70.ID(),
 * 			AccessGroup:     defaultBbc7ev.AccessGroupName,
 * 			VswitchId:       defaultoZAPmO.ID(),
 * 			FileSystemId:    defaultVtUpDh.ID(),
 * 			AccessPointName: pulumi.String(name),
 * 			PosixUser: &nas.AccessPointPosixUserArgs{
 * 				PosixGroupId: pulumi.Int(123),
 * 				PosixUserId:  pulumi.Int(123),
 * 			},
 * 			RootPathPermission: &nas.AccessPointRootPathPermissionArgs{
 * 				OwnerGroupId: pulumi.Int(1),
 * 				OwnerUserId:  pulumi.Int(1),
 * 				Permission:   pulumi.String("0777"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.nas.AccessGroup;
 * import com.pulumi.alicloud.nas.AccessGroupArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.nas.AccessPoint;
 * import com.pulumi.alicloud.nas.AccessPointArgs;
 * import com.pulumi.alicloud.nas.inputs.AccessPointPosixUserArgs;
 * import com.pulumi.alicloud.nas.inputs.AccessPointRootPathPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var regionId = config.get("regionId").orElse("cn-hangzhou");
 *         final var azone = config.get("azone").orElse("cn-hangzhou-g");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultkyVC70 = new Network("defaultkyVC70", NetworkArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .description("接入点测试noRootDirectory")
 *             .build());
 *         var defaultoZAPmO = new Switch("defaultoZAPmO", SwitchArgs.builder()
 *             .vpcId(defaultkyVC70.id())
 *             .zoneId(default_.zones()[0].id())
 *             .cidrBlock("172.16.0.0/24")
 *             .build());
 *         var defaultBbc7ev = new AccessGroup("defaultBbc7ev", AccessGroupArgs.builder()
 *             .accessGroupType("Vpc")
 *             .accessGroupName(name)
 *             .fileSystemType("standard")
 *             .build());
 *         var defaultVtUpDh = new FileSystem("defaultVtUpDh", FileSystemArgs.builder()
 *             .storageType("Performance")
 *             .zoneId(azone)
 *             .encryptType("0")
 *             .protocolType("NFS")
 *             .fileSystemType("standard")
 *             .description("AccessPointnoRootDirectory")
 *             .build());
 *         var defaultAccessPoint = new AccessPoint("defaultAccessPoint", AccessPointArgs.builder()
 *             .vpcId(defaultkyVC70.id())
 *             .accessGroup(defaultBbc7ev.accessGroupName())
 *             .vswitchId(defaultoZAPmO.id())
 *             .fileSystemId(defaultVtUpDh.id())
 *             .accessPointName(name)
 *             .posixUser(AccessPointPosixUserArgs.builder()
 *                 .posixGroupId("123")
 *                 .posixUserId("123")
 *                 .build())
 *             .rootPathPermission(AccessPointRootPathPermissionArgs.builder()
 *                 .ownerGroupId("1")
 *                 .ownerUserId("1")
 *                 .permission("0777")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   regionId:
 *     type: string
 *     default: cn-hangzhou
 *   azone:
 *     type: string
 *     default: cn-hangzhou-g
 * resources:
 *   defaultkyVC70:
 *     type: alicloud:vpc:Network
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *       description: 接入点测试noRootDirectory
 *   defaultoZAPmO:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${defaultkyVC70.id}
 *       zoneId: ${default.zones[0].id}
 *       cidrBlock: 172.16.0.0/24
 *   defaultBbc7ev:
 *     type: alicloud:nas:AccessGroup
 *     properties:
 *       accessGroupType: Vpc
 *       accessGroupName: ${name}
 *       fileSystemType: standard
 *   defaultVtUpDh:
 *     type: alicloud:nas:FileSystem
 *     properties:
 *       storageType: Performance
 *       zoneId: ${azone}
 *       encryptType: '0'
 *       protocolType: NFS
 *       fileSystemType: standard
 *       description: AccessPointnoRootDirectory
 *   defaultAccessPoint:
 *     type: alicloud:nas:AccessPoint
 *     name: default
 *     properties:
 *       vpcId: ${defaultkyVC70.id}
 *       accessGroup: ${defaultBbc7ev.accessGroupName}
 *       vswitchId: ${defaultoZAPmO.id}
 *       fileSystemId: ${defaultVtUpDh.id}
 *       accessPointName: ${name}
 *       posixUser:
 *         posixGroupId: '123'
 *         posixUserId: '123'
 *       rootPathPermission:
 *         ownerGroupId: '1'
 *         ownerUserId: '1'
 *         permission: '0777'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NAS Access Point can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/accessPoint:AccessPoint example <file_system_id>:<access_point_id>
 * ```
 * @property accessGroup The permission group name.
 * @property accessPointName The Access Point Name.
 * @property enabledRam Whether to enable the RAM policy.
 * @property fileSystemId The ID of the file system.
 * @property posixUser The Posix user. See `posix_user` below.
 * @property rootPath The root directory.
 * @property rootPathPermission Root permissions. See `root_path_permission` below.
 * @property vpcId The ID of the VPC.
 * @property vswitchId The vSwitch ID.
 */
public data class AccessPointArgs(
    public val accessGroup: Output<String>? = null,
    public val accessPointName: Output<String>? = null,
    public val enabledRam: Output<Boolean>? = null,
    public val fileSystemId: Output<String>? = null,
    public val posixUser: Output<AccessPointPosixUserArgs>? = null,
    public val rootPath: Output<String>? = null,
    public val rootPathPermission: Output<AccessPointRootPathPermissionArgs>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.AccessPointArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.AccessPointArgs =
        com.pulumi.alicloud.nas.AccessPointArgs.builder()
            .accessGroup(accessGroup?.applyValue({ args0 -> args0 }))
            .accessPointName(accessPointName?.applyValue({ args0 -> args0 }))
            .enabledRam(enabledRam?.applyValue({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .posixUser(posixUser?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rootPath(rootPath?.applyValue({ args0 -> args0 }))
            .rootPathPermission(
                rootPathPermission?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPointArgs].
 */
@PulumiTagMarker
public class AccessPointArgsBuilder internal constructor() {
    private var accessGroup: Output<String>? = null

    private var accessPointName: Output<String>? = null

    private var enabledRam: Output<Boolean>? = null

    private var fileSystemId: Output<String>? = null

    private var posixUser: Output<AccessPointPosixUserArgs>? = null

    private var rootPath: Output<String>? = null

    private var rootPathPermission: Output<AccessPointRootPathPermissionArgs>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The permission group name.
     */
    @JvmName("anvhfjwnyinqyfrs")
    public suspend fun accessGroup(`value`: Output<String>) {
        this.accessGroup = value
    }

    /**
     * @param value The Access Point Name.
     */
    @JvmName("lvxkluxiqvtvndqt")
    public suspend fun accessPointName(`value`: Output<String>) {
        this.accessPointName = value
    }

    /**
     * @param value Whether to enable the RAM policy.
     */
    @JvmName("gvtqwgysdkqgjrjb")
    public suspend fun enabledRam(`value`: Output<Boolean>) {
        this.enabledRam = value
    }

    /**
     * @param value The ID of the file system.
     */
    @JvmName("mhwmvaktecvtprdk")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The Posix user. See `posix_user` below.
     */
    @JvmName("xtfuyemukhcfujty")
    public suspend fun posixUser(`value`: Output<AccessPointPosixUserArgs>) {
        this.posixUser = value
    }

    /**
     * @param value The root directory.
     */
    @JvmName("bxpigcauategqiax")
    public suspend fun rootPath(`value`: Output<String>) {
        this.rootPath = value
    }

    /**
     * @param value Root permissions. See `root_path_permission` below.
     */
    @JvmName("ppactvafrcqapipj")
    public suspend fun rootPathPermission(`value`: Output<AccessPointRootPathPermissionArgs>) {
        this.rootPathPermission = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("potxoitulxhxyryf")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The vSwitch ID.
     */
    @JvmName("yubtqxmvuafxeeww")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The permission group name.
     */
    @JvmName("brqrjtclcrwdcalg")
    public suspend fun accessGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessGroup = mapped
    }

    /**
     * @param value The Access Point Name.
     */
    @JvmName("rbmwsdbafmmllhab")
    public suspend fun accessPointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPointName = mapped
    }

    /**
     * @param value Whether to enable the RAM policy.
     */
    @JvmName("crpcqxpcwhgtmpjy")
    public suspend fun enabledRam(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledRam = mapped
    }

    /**
     * @param value The ID of the file system.
     */
    @JvmName("lnupkrsxacewiqay")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The Posix user. See `posix_user` below.
     */
    @JvmName("avekxuidsiqfgijw")
    public suspend fun posixUser(`value`: AccessPointPosixUserArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.posixUser = mapped
    }

    /**
     * @param argument The Posix user. See `posix_user` below.
     */
    @JvmName("yyrjovadlltvlffg")
    public suspend fun posixUser(argument: suspend AccessPointPosixUserArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPointPosixUserArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.posixUser = mapped
    }

    /**
     * @param value The root directory.
     */
    @JvmName("uqyvejgnlhbqdnpw")
    public suspend fun rootPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootPath = mapped
    }

    /**
     * @param value Root permissions. See `root_path_permission` below.
     */
    @JvmName("vhhjuxpxwgexlpjq")
    public suspend fun rootPathPermission(`value`: AccessPointRootPathPermissionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootPathPermission = mapped
    }

    /**
     * @param argument Root permissions. See `root_path_permission` below.
     */
    @JvmName("gbmvdvpyunhcbjhr")
    public suspend fun rootPathPermission(argument: suspend AccessPointRootPathPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPointRootPathPermissionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rootPathPermission = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("mqanqqdmcevfsjnj")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The vSwitch ID.
     */
    @JvmName("xusadmxmokbpwuuo")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): AccessPointArgs = AccessPointArgs(
        accessGroup = accessGroup,
        accessPointName = accessPointName,
        enabledRam = enabledRam,
        fileSystemId = fileSystemId,
        posixUser = posixUser,
        rootPath = rootPath,
        rootPathPermission = rootPathPermission,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
