@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.alicloud.nas.AccessRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a NAS Access Rule resource.
 * For information about NAS Access Rule and how to use it, see [What is Access Rule](https://www.alibabacloud.com/help/en/nas/developer-reference/api-nas-2017-06-26-createaccessrule).
 * > **NOTE:** Available since v1.34.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultAccessGroup = new alicloud.nas.AccessGroup("default", {
 *     accessGroupType: "Vpc",
 *     description: "ExtremeAccessGroup",
 *     accessGroupName: `terraform-example-${_default.result}`,
 *     fileSystemType: "extreme",
 * });
 * const defaultAccessRule = new alicloud.nas.AccessRule("default", {
 *     accessGroupName: defaultAccessGroup.accessGroupName,
 *     rwAccessType: "RDONLY",
 *     ipv6SourceCidrIp: "::1",
 *     userAccessType: "no_squash",
 *     priority: 1,
 *     fileSystemType: "extreme",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_access_group = alicloud.nas.AccessGroup("default",
 *     access_group_type="Vpc",
 *     description="ExtremeAccessGroup",
 *     access_group_name=f"terraform-example-{default['result']}",
 *     file_system_type="extreme")
 * default_access_rule = alicloud.nas.AccessRule("default",
 *     access_group_name=default_access_group.access_group_name,
 *     rw_access_type="RDONLY",
 *     ipv6_source_cidr_ip="::1",
 *     user_access_type="no_squash",
 *     priority=1,
 *     file_system_type="extreme")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultAccessGroup = new AliCloud.Nas.AccessGroup("default", new()
 *     {
 *         AccessGroupType = "Vpc",
 *         Description = "ExtremeAccessGroup",
 *         AccessGroupName = $"terraform-example-{@default.Result}",
 *         FileSystemType = "extreme",
 *     });
 *     var defaultAccessRule = new AliCloud.Nas.AccessRule("default", new()
 *     {
 *         AccessGroupName = defaultAccessGroup.AccessGroupName,
 *         RwAccessType = "RDONLY",
 *         Ipv6SourceCidrIp = "::1",
 *         UserAccessType = "no_squash",
 *         Priority = 1,
 *         FileSystemType = "extreme",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAccessGroup, err := nas.NewAccessGroup(ctx, "default", &nas.AccessGroupArgs{
 * 			AccessGroupType: pulumi.String("Vpc"),
 * 			Description:     pulumi.String("ExtremeAccessGroup"),
 * 			AccessGroupName: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			FileSystemType:  pulumi.String("extreme"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewAccessRule(ctx, "default", &nas.AccessRuleArgs{
 * 			AccessGroupName:  defaultAccessGroup.AccessGroupName,
 * 			RwAccessType:     pulumi.String("RDONLY"),
 * 			Ipv6SourceCidrIp: pulumi.String("::1"),
 * 			UserAccessType:   pulumi.String("no_squash"),
 * 			Priority:         pulumi.Int(1),
 * 			FileSystemType:   pulumi.String("extreme"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.nas.AccessGroup;
 * import com.pulumi.alicloud.nas.AccessGroupArgs;
 * import com.pulumi.alicloud.nas.AccessRule;
 * import com.pulumi.alicloud.nas.AccessRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultAccessGroup = new AccessGroup("defaultAccessGroup", AccessGroupArgs.builder()
 *             .accessGroupType("Vpc")
 *             .description("ExtremeAccessGroup")
 *             .accessGroupName(String.format("terraform-example-%s", default_.result()))
 *             .fileSystemType("extreme")
 *             .build());
 *         var defaultAccessRule = new AccessRule("defaultAccessRule", AccessRuleArgs.builder()
 *             .accessGroupName(defaultAccessGroup.accessGroupName())
 *             .rwAccessType("RDONLY")
 *             .ipv6SourceCidrIp("::1")
 *             .userAccessType("no_squash")
 *             .priority("1")
 *             .fileSystemType("extreme")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultAccessGroup:
 *     type: alicloud:nas:AccessGroup
 *     name: default
 *     properties:
 *       accessGroupType: Vpc
 *       description: ExtremeAccessGroup
 *       accessGroupName: terraform-example-${default.result}
 *       fileSystemType: extreme
 *   defaultAccessRule:
 *     type: alicloud:nas:AccessRule
 *     name: default
 *     properties:
 *       accessGroupName: ${defaultAccessGroup.accessGroupName}
 *       rwAccessType: RDONLY
 *       ipv6SourceCidrIp: ::1
 *       userAccessType: no_squash
 *       priority: '1'
 *       fileSystemType: extreme
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NAS Access Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/accessRule:AccessRule example <access_group_name>:<file_system_type>:<access_rule_id>
 * ```
 * @property accessGroupName AccessGroupName.
 * @property fileSystemType filesystem type. include standard, extreme.
 * @property ipv6SourceCidrIp Ipv6SourceCidrIp.
 * @property priority Priority.
 * @property rwAccessType RWAccess.
 * @property sourceCidrIp SourceCidrIp.
 * @property userAccessType UserAccess.
 */
public data class AccessRuleArgs(
    public val accessGroupName: Output<String>? = null,
    public val fileSystemType: Output<String>? = null,
    public val ipv6SourceCidrIp: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val rwAccessType: Output<String>? = null,
    public val sourceCidrIp: Output<String>? = null,
    public val userAccessType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.AccessRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.AccessRuleArgs =
        com.pulumi.alicloud.nas.AccessRuleArgs.builder()
            .accessGroupName(accessGroupName?.applyValue({ args0 -> args0 }))
            .fileSystemType(fileSystemType?.applyValue({ args0 -> args0 }))
            .ipv6SourceCidrIp(ipv6SourceCidrIp?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .rwAccessType(rwAccessType?.applyValue({ args0 -> args0 }))
            .sourceCidrIp(sourceCidrIp?.applyValue({ args0 -> args0 }))
            .userAccessType(userAccessType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessRuleArgs].
 */
@PulumiTagMarker
public class AccessRuleArgsBuilder internal constructor() {
    private var accessGroupName: Output<String>? = null

    private var fileSystemType: Output<String>? = null

    private var ipv6SourceCidrIp: Output<String>? = null

    private var priority: Output<Int>? = null

    private var rwAccessType: Output<String>? = null

    private var sourceCidrIp: Output<String>? = null

    private var userAccessType: Output<String>? = null

    /**
     * @param value AccessGroupName.
     */
    @JvmName("daygoagjlfbukyop")
    public suspend fun accessGroupName(`value`: Output<String>) {
        this.accessGroupName = value
    }

    /**
     * @param value filesystem type. include standard, extreme.
     */
    @JvmName("gvoatexdntiidqit")
    public suspend fun fileSystemType(`value`: Output<String>) {
        this.fileSystemType = value
    }

    /**
     * @param value Ipv6SourceCidrIp.
     */
    @JvmName("vjvvpjoguqfhukhs")
    public suspend fun ipv6SourceCidrIp(`value`: Output<String>) {
        this.ipv6SourceCidrIp = value
    }

    /**
     * @param value Priority.
     */
    @JvmName("rbgmpbysjsrfgbaf")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value RWAccess.
     */
    @JvmName("wggyprguvetppamt")
    public suspend fun rwAccessType(`value`: Output<String>) {
        this.rwAccessType = value
    }

    /**
     * @param value SourceCidrIp.
     */
    @JvmName("jubtutlbjaokjvck")
    public suspend fun sourceCidrIp(`value`: Output<String>) {
        this.sourceCidrIp = value
    }

    /**
     * @param value UserAccess.
     */
    @JvmName("yusqojtklywidmni")
    public suspend fun userAccessType(`value`: Output<String>) {
        this.userAccessType = value
    }

    /**
     * @param value AccessGroupName.
     */
    @JvmName("jnfjiaggikfintii")
    public suspend fun accessGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessGroupName = mapped
    }

    /**
     * @param value filesystem type. include standard, extreme.
     */
    @JvmName("mnkkieevkqnsbivv")
    public suspend fun fileSystemType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemType = mapped
    }

    /**
     * @param value Ipv6SourceCidrIp.
     */
    @JvmName("ddjgtlxgsppupxor")
    public suspend fun ipv6SourceCidrIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6SourceCidrIp = mapped
    }

    /**
     * @param value Priority.
     */
    @JvmName("kxnlainryvqlphwq")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value RWAccess.
     */
    @JvmName("hsixxaayanjjrjxd")
    public suspend fun rwAccessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rwAccessType = mapped
    }

    /**
     * @param value SourceCidrIp.
     */
    @JvmName("qtkuindmqqkntwld")
    public suspend fun sourceCidrIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCidrIp = mapped
    }

    /**
     * @param value UserAccess.
     */
    @JvmName("qcglxtscdeuqwcpq")
    public suspend fun userAccessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAccessType = mapped
    }

    internal fun build(): AccessRuleArgs = AccessRuleArgs(
        accessGroupName = accessGroupName,
        fileSystemType = fileSystemType,
        ipv6SourceCidrIp = ipv6SourceCidrIp,
        priority = priority,
        rwAccessType = rwAccessType,
        sourceCidrIp = sourceCidrIp,
        userAccessType = userAccessType,
    )
}
