@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AutoSnapshotPolicy].
 */
@PulumiTagMarker
public class AutoSnapshotPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutoSnapshotPolicyArgs = AutoSnapshotPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutoSnapshotPolicyArgsBuilder.() -> Unit) {
        val builder = AutoSnapshotPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AutoSnapshotPolicy {
        val builtJavaResource = com.pulumi.alicloud.nas.AutoSnapshotPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AutoSnapshotPolicy(builtJavaResource)
    }
}

/**
 * Provides a NAS Auto Snapshot Policy resource. Automatic snapshot policy.
 * For information about NAS Auto Snapshot Policy and how to use it, see [What is Auto Snapshot Policy](https://www.alibabacloud.com/help/en/doc-detail/135662.html)).
 * > **NOTE:** Available since v1.153.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.nas.AutoSnapshotPolicy("default", {
 *     timePoints: [
 *         "0",
 *         "1",
 *         "2",
 *     ],
 *     retentionDays: 1,
 *     repeatWeekdays: [
 *         "2",
 *         "3",
 *         "4",
 *     ],
 *     autoSnapshotPolicyName: name,
 *     fileSystemType: "extreme",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.nas.AutoSnapshotPolicy("default",
 *     time_points=[
 *         "0",
 *         "1",
 *         "2",
 *     ],
 *     retention_days=1,
 *     repeat_weekdays=[
 *         "2",
 *         "3",
 *         "4",
 *     ],
 *     auto_snapshot_policy_name=name,
 *     file_system_type="extreme")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Nas.AutoSnapshotPolicy("default", new()
 *     {
 *         TimePoints = new[]
 *         {
 *             "0",
 *             "1",
 *             "2",
 *         },
 *         RetentionDays = 1,
 *         RepeatWeekdays = new[]
 *         {
 *             "2",
 *             "3",
 *             "4",
 *         },
 *         AutoSnapshotPolicyName = name,
 *         FileSystemType = "extreme",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := nas.NewAutoSnapshotPolicy(ctx, "default", &nas.AutoSnapshotPolicyArgs{
 * 			TimePoints: pulumi.StringArray{
 * 				pulumi.String("0"),
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 			},
 * 			RetentionDays: pulumi.Int(1),
 * 			RepeatWeekdays: pulumi.StringArray{
 * 				pulumi.String("2"),
 * 				pulumi.String("3"),
 * 				pulumi.String("4"),
 * 			},
 * 			AutoSnapshotPolicyName: pulumi.String(name),
 * 			FileSystemType:         pulumi.String("extreme"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.AutoSnapshotPolicy;
 * import com.pulumi.alicloud.nas.AutoSnapshotPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new AutoSnapshotPolicy("default", AutoSnapshotPolicyArgs.builder()
 *             .timePoints(
 *                 "0",
 *                 "1",
 *                 "2")
 *             .retentionDays("1")
 *             .repeatWeekdays(
 *                 "2",
 *                 "3",
 *                 "4")
 *             .autoSnapshotPolicyName(name)
 *             .fileSystemType("extreme")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:nas:AutoSnapshotPolicy
 *     properties:
 *       timePoints:
 *         - '0'
 *         - '1'
 *         - '2'
 *       retentionDays: '1'
 *       repeatWeekdays:
 *         - '2'
 *         - '3'
 *         - '4'
 *       autoSnapshotPolicyName: ${name}
 *       fileSystemType: extreme
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NAS Auto Snapshot Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/autoSnapshotPolicy:AutoSnapshotPolicy example <id>
 * ```
 */
public class AutoSnapshotPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.nas.AutoSnapshotPolicy,
) : KotlinCustomResource(javaResource, AutoSnapshotPolicyMapper) {
    /**
     * The name of the automatic snapshot policy. Limits:
     * - The name must be `2` to `128` characters in length,
     * - The name must start with a letter.
     * - The name can contain digits, colons (:), underscores (_), and hyphens (-). The name cannot start with `http://` or `https://`.
     * - The value of this parameter is empty by default.
     */
    public val autoSnapshotPolicyName: Output<String>?
        get() = javaResource.autoSnapshotPolicyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The file system type.
     */
    public val fileSystemType: Output<String>
        get() = javaResource.fileSystemType().applyValue({ args0 -> args0 })

    /**
     * The day on which an auto snapshot is created.
     * - A maximum of 7 time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    public val repeatWeekdays: Output<List<String>>
        get() = javaResource.repeatWeekdays().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The number of days for which you want to retain auto snapshots. Unit: days. Valid values:
     * - `-1`: the default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
     */
    public val retentionDays: Output<Int>
        get() = javaResource.retentionDays().applyValue({ args0 -> args0 })

    /**
     * The status of the automatic snapshot policy.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The point in time at which an auto snapshot is created.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    public val timePoints: Output<List<String>>
        get() = javaResource.timePoints().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object AutoSnapshotPolicyMapper : ResourceMapper<AutoSnapshotPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nas.AutoSnapshotPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AutoSnapshotPolicy = AutoSnapshotPolicy(
        javaResource as
            com.pulumi.alicloud.nas.AutoSnapshotPolicy,
    )
}

/**
 * @see [AutoSnapshotPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AutoSnapshotPolicy].
 */
public suspend fun autoSnapshotPolicy(
    name: String,
    block: suspend AutoSnapshotPolicyResourceBuilder.() -> Unit,
): AutoSnapshotPolicy {
    val builder = AutoSnapshotPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AutoSnapshotPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun autoSnapshotPolicy(name: String): AutoSnapshotPolicy {
    val builder = AutoSnapshotPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
