@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.alicloud.nas.AutoSnapshotPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a NAS Auto Snapshot Policy resource. Automatic snapshot policy.
 * For information about NAS Auto Snapshot Policy and how to use it, see [What is Auto Snapshot Policy](https://www.alibabacloud.com/help/en/doc-detail/135662.html)).
 * > **NOTE:** Available since v1.153.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.nas.AutoSnapshotPolicy("default", {
 *     timePoints: [
 *         "0",
 *         "1",
 *         "2",
 *     ],
 *     retentionDays: 1,
 *     repeatWeekdays: [
 *         "2",
 *         "3",
 *         "4",
 *     ],
 *     autoSnapshotPolicyName: name,
 *     fileSystemType: "extreme",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.nas.AutoSnapshotPolicy("default",
 *     time_points=[
 *         "0",
 *         "1",
 *         "2",
 *     ],
 *     retention_days=1,
 *     repeat_weekdays=[
 *         "2",
 *         "3",
 *         "4",
 *     ],
 *     auto_snapshot_policy_name=name,
 *     file_system_type="extreme")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Nas.AutoSnapshotPolicy("default", new()
 *     {
 *         TimePoints = new[]
 *         {
 *             "0",
 *             "1",
 *             "2",
 *         },
 *         RetentionDays = 1,
 *         RepeatWeekdays = new[]
 *         {
 *             "2",
 *             "3",
 *             "4",
 *         },
 *         AutoSnapshotPolicyName = name,
 *         FileSystemType = "extreme",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := nas.NewAutoSnapshotPolicy(ctx, "default", &nas.AutoSnapshotPolicyArgs{
 * 			TimePoints: pulumi.StringArray{
 * 				pulumi.String("0"),
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 			},
 * 			RetentionDays: pulumi.Int(1),
 * 			RepeatWeekdays: pulumi.StringArray{
 * 				pulumi.String("2"),
 * 				pulumi.String("3"),
 * 				pulumi.String("4"),
 * 			},
 * 			AutoSnapshotPolicyName: pulumi.String(name),
 * 			FileSystemType:         pulumi.String("extreme"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.AutoSnapshotPolicy;
 * import com.pulumi.alicloud.nas.AutoSnapshotPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new AutoSnapshotPolicy("default", AutoSnapshotPolicyArgs.builder()
 *             .timePoints(
 *                 "0",
 *                 "1",
 *                 "2")
 *             .retentionDays("1")
 *             .repeatWeekdays(
 *                 "2",
 *                 "3",
 *                 "4")
 *             .autoSnapshotPolicyName(name)
 *             .fileSystemType("extreme")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:nas:AutoSnapshotPolicy
 *     properties:
 *       timePoints:
 *         - '0'
 *         - '1'
 *         - '2'
 *       retentionDays: '1'
 *       repeatWeekdays:
 *         - '2'
 *         - '3'
 *         - '4'
 *       autoSnapshotPolicyName: ${name}
 *       fileSystemType: extreme
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NAS Auto Snapshot Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/autoSnapshotPolicy:AutoSnapshotPolicy example <id>
 * ```
 * @property autoSnapshotPolicyName The name of the automatic snapshot policy. Limits:
 * - The name must be `2` to `128` characters in length,
 * - The name must start with a letter.
 * - The name can contain digits, colons (:), underscores (_), and hyphens (-). The name cannot start with `http://` or `https://`.
 * - The value of this parameter is empty by default.
 * @property fileSystemType The file system type.
 * @property repeatWeekdays The day on which an auto snapshot is created.
 * - A maximum of 7 time points can be selected.
 * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
 * @property retentionDays The number of days for which you want to retain auto snapshots. Unit: days. Valid values:
 * - `-1`: the default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
 * @property timePoints The point in time at which an auto snapshot is created.
 * - A maximum of 24 time points can be selected.
 * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
 */
public data class AutoSnapshotPolicyArgs(
    public val autoSnapshotPolicyName: Output<String>? = null,
    public val fileSystemType: Output<String>? = null,
    public val repeatWeekdays: Output<List<String>>? = null,
    public val retentionDays: Output<Int>? = null,
    public val timePoints: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.AutoSnapshotPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.AutoSnapshotPolicyArgs =
        com.pulumi.alicloud.nas.AutoSnapshotPolicyArgs.builder()
            .autoSnapshotPolicyName(autoSnapshotPolicyName?.applyValue({ args0 -> args0 }))
            .fileSystemType(fileSystemType?.applyValue({ args0 -> args0 }))
            .repeatWeekdays(repeatWeekdays?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .timePoints(timePoints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AutoSnapshotPolicyArgs].
 */
@PulumiTagMarker
public class AutoSnapshotPolicyArgsBuilder internal constructor() {
    private var autoSnapshotPolicyName: Output<String>? = null

    private var fileSystemType: Output<String>? = null

    private var repeatWeekdays: Output<List<String>>? = null

    private var retentionDays: Output<Int>? = null

    private var timePoints: Output<List<String>>? = null

    /**
     * @param value The name of the automatic snapshot policy. Limits:
     * - The name must be `2` to `128` characters in length,
     * - The name must start with a letter.
     * - The name can contain digits, colons (:), underscores (_), and hyphens (-). The name cannot start with `http://` or `https://`.
     * - The value of this parameter is empty by default.
     */
    @JvmName("mnphwwkxrcmowqgf")
    public suspend fun autoSnapshotPolicyName(`value`: Output<String>) {
        this.autoSnapshotPolicyName = value
    }

    /**
     * @param value The file system type.
     */
    @JvmName("gfqhqwcavhfkmfse")
    public suspend fun fileSystemType(`value`: Output<String>) {
        this.fileSystemType = value
    }

    /**
     * @param value The day on which an auto snapshot is created.
     * - A maximum of 7 time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("yamgbjqvaxwmhrgc")
    public suspend fun repeatWeekdays(`value`: Output<List<String>>) {
        this.repeatWeekdays = value
    }

    @JvmName("selaaohkejhemrgd")
    public suspend fun repeatWeekdays(vararg values: Output<String>) {
        this.repeatWeekdays = Output.all(values.asList())
    }

    /**
     * @param values The day on which an auto snapshot is created.
     * - A maximum of 7 time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("hiutdwpoejltrgxb")
    public suspend fun repeatWeekdays(values: List<Output<String>>) {
        this.repeatWeekdays = Output.all(values)
    }

    /**
     * @param value The number of days for which you want to retain auto snapshots. Unit: days. Valid values:
     * - `-1`: the default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
     */
    @JvmName("jfcmjdhbwydkiyvo")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value The point in time at which an auto snapshot is created.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("tjgwkaousjpvqfin")
    public suspend fun timePoints(`value`: Output<List<String>>) {
        this.timePoints = value
    }

    @JvmName("wsuvlnwcojcuuvsy")
    public suspend fun timePoints(vararg values: Output<String>) {
        this.timePoints = Output.all(values.asList())
    }

    /**
     * @param values The point in time at which an auto snapshot is created.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("ubpriwcrdshhfetr")
    public suspend fun timePoints(values: List<Output<String>>) {
        this.timePoints = Output.all(values)
    }

    /**
     * @param value The name of the automatic snapshot policy. Limits:
     * - The name must be `2` to `128` characters in length,
     * - The name must start with a letter.
     * - The name can contain digits, colons (:), underscores (_), and hyphens (-). The name cannot start with `http://` or `https://`.
     * - The value of this parameter is empty by default.
     */
    @JvmName("wyvhbcapwrhpsjck")
    public suspend fun autoSnapshotPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoSnapshotPolicyName = mapped
    }

    /**
     * @param value The file system type.
     */
    @JvmName("dadwhrinwvsbaerv")
    public suspend fun fileSystemType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemType = mapped
    }

    /**
     * @param value The day on which an auto snapshot is created.
     * - A maximum of 7 time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("qdtchrstnegeceqh")
    public suspend fun repeatWeekdays(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repeatWeekdays = mapped
    }

    /**
     * @param values The day on which an auto snapshot is created.
     * - A maximum of 7 time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("enaudqwqgebhhrnp")
    public suspend fun repeatWeekdays(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repeatWeekdays = mapped
    }

    /**
     * @param value The number of days for which you want to retain auto snapshots. Unit: days. Valid values:
     * - `-1`: the default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
     */
    @JvmName("cosgthxtqajolaqw")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value The point in time at which an auto snapshot is created.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("pufkpwdlbpsdpmsj")
    public suspend fun timePoints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timePoints = mapped
    }

    /**
     * @param values The point in time at which an auto snapshot is created.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("wsggkhxetfiuyase")
    public suspend fun timePoints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timePoints = mapped
    }

    internal fun build(): AutoSnapshotPolicyArgs = AutoSnapshotPolicyArgs(
        autoSnapshotPolicyName = autoSnapshotPolicyName,
        fileSystemType = fileSystemType,
        repeatWeekdays = repeatWeekdays,
        retentionDays = retentionDays,
        timePoints = timePoints,
    )
}
