@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DataFlow].
 */
@PulumiTagMarker
public class DataFlowResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataFlowArgs = DataFlowArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataFlowArgsBuilder.() -> Unit) {
        val builder = DataFlowArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataFlow {
        val builtJavaResource = com.pulumi.alicloud.nas.DataFlow(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataFlow(builtJavaResource)
    }
}

/**
 * Provides a Network Attached Storage (NAS) Data Flow resource.
 * For information about Network Attached Storage (NAS) Data Flow and how to use it, see [What is Data Flow](https://www.alibabacloud.com/help/en/doc-detail/27530.html).
 * > **NOTE:** Available since v1.153.0.
 * ## Import
 * Network Attached Storage (NAS) Data Flow can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/dataFlow:DataFlow example <file_system_id>:<data_flow_id>
 * ```
 */
public class DataFlow internal constructor(
    override val javaResource: com.pulumi.alicloud.nas.DataFlow,
) : KotlinCustomResource(javaResource, DataFlowMapper) {
    /**
     * The ID of the Data flow.
     */
    public val dataFlowId: Output<String>
        get() = javaResource.dataFlowId().applyValue({ args0 -> args0 })

    /**
     * The Description of the data flow. Restrictions:
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The dry run.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the file system.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Fileset.
     */
    public val fsetId: Output<String>
        get() = javaResource.fsetId().applyValue({ args0 -> args0 })

    /**
     * The security protection type of the source storage. If the source storage must be accessed through security protection, specify the security protection type of the source storage. Value:
     * - `NONE` (default): Indicates that the source storage does not need to be accessed through security protection.
     * - `SSL`: Protects access through SSL certificates.
     */
    public val sourceSecurityType: Output<String>
        get() = javaResource.sourceSecurityType().applyValue({ args0 -> args0 })

    /**
     * The access path of the source store. Format: `<storage type>://<path>`. Among them:
     * - storage type: currently only OSS is supported.
     * - path: the bucket name of OSS.
     * - Only lowercase letters, numbers, and dashes (-) are supported and must start and end with lowercase letters or numbers.
     */
    public val sourceStorage: Output<String>
        get() = javaResource.sourceStorage().applyValue({ args0 -> args0 })

    /**
     * The status of the Data flow. Valid values: `Running`, `Stopped`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The maximum transmission bandwidth of data flow, unit: `MB/s`. Valid values: `1200`, `1500`, `600`. **NOTE:** The transmission bandwidth of data flow must be less than the IO bandwidth of the file system.
     */
    public val throughput: Output<Int>
        get() = javaResource.throughput().applyValue({ args0 -> args0 })
}

public object DataFlowMapper : ResourceMapper<DataFlow> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nas.DataFlow::class == javaResource::class

    override fun map(javaResource: Resource): DataFlow = DataFlow(
        javaResource as
            com.pulumi.alicloud.nas.DataFlow,
    )
}

/**
 * @see [DataFlow].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataFlow].
 */
public suspend fun dataFlow(name: String, block: suspend DataFlowResourceBuilder.() -> Unit): DataFlow {
    val builder = DataFlowResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataFlow].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataFlow(name: String): DataFlow {
    val builder = DataFlowResourceBuilder()
    builder.name(name)
    return builder.build()
}
