@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.alicloud.nas.DataFlowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Network Attached Storage (NAS) Data Flow resource.
 * For information about Network Attached Storage (NAS) Data Flow and how to use it, see [What is Data Flow](https://www.alibabacloud.com/help/en/doc-detail/27530.html).
 * > **NOTE:** Available since v1.153.0.
 * ## Import
 * Network Attached Storage (NAS) Data Flow can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/dataFlow:DataFlow example <file_system_id>:<data_flow_id>
 * ```
 * @property description The Description of the data flow. Restrictions:
 * @property dryRun The dry run.
 * @property fileSystemId The ID of the file system.
 * @property fsetId The ID of the Fileset.
 * @property sourceSecurityType The security protection type of the source storage. If the source storage must be accessed through security protection, specify the security protection type of the source storage. Value:
 * - `NONE` (default): Indicates that the source storage does not need to be accessed through security protection.
 * - `SSL`: Protects access through SSL certificates.
 * @property sourceStorage The access path of the source store. Format: `<storage type>://<path>`. Among them:
 * - storage type: currently only OSS is supported.
 * - path: the bucket name of OSS.
 * - Only lowercase letters, numbers, and dashes (-) are supported and must start and end with lowercase letters or numbers.
 * @property status The status of the Data flow. Valid values: `Running`, `Stopped`.
 * @property throughput The maximum transmission bandwidth of data flow, unit: `MB/s`. Valid values: `1200`, `1500`, `600`. **NOTE:** The transmission bandwidth of data flow must be less than the IO bandwidth of the file system.
 */
public data class DataFlowArgs(
    public val description: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val fileSystemId: Output<String>? = null,
    public val fsetId: Output<String>? = null,
    public val sourceSecurityType: Output<String>? = null,
    public val sourceStorage: Output<String>? = null,
    public val status: Output<String>? = null,
    public val throughput: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.DataFlowArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.DataFlowArgs =
        com.pulumi.alicloud.nas.DataFlowArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .fsetId(fsetId?.applyValue({ args0 -> args0 }))
            .sourceSecurityType(sourceSecurityType?.applyValue({ args0 -> args0 }))
            .sourceStorage(sourceStorage?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .throughput(throughput?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataFlowArgs].
 */
@PulumiTagMarker
public class DataFlowArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var fileSystemId: Output<String>? = null

    private var fsetId: Output<String>? = null

    private var sourceSecurityType: Output<String>? = null

    private var sourceStorage: Output<String>? = null

    private var status: Output<String>? = null

    private var throughput: Output<Int>? = null

    /**
     * @param value The Description of the data flow. Restrictions:
     */
    @JvmName("uvipprpwknpycbmx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The dry run.
     */
    @JvmName("oerdhumkcguuaslp")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The ID of the file system.
     */
    @JvmName("erqjssvvwslqbtnw")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The ID of the Fileset.
     */
    @JvmName("uenwxmcpkpmdpqjj")
    public suspend fun fsetId(`value`: Output<String>) {
        this.fsetId = value
    }

    /**
     * @param value The security protection type of the source storage. If the source storage must be accessed through security protection, specify the security protection type of the source storage. Value:
     * - `NONE` (default): Indicates that the source storage does not need to be accessed through security protection.
     * - `SSL`: Protects access through SSL certificates.
     */
    @JvmName("aulkkofkogttujfv")
    public suspend fun sourceSecurityType(`value`: Output<String>) {
        this.sourceSecurityType = value
    }

    /**
     * @param value The access path of the source store. Format: `<storage type>://<path>`. Among them:
     * - storage type: currently only OSS is supported.
     * - path: the bucket name of OSS.
     * - Only lowercase letters, numbers, and dashes (-) are supported and must start and end with lowercase letters or numbers.
     */
    @JvmName("ikfpnwpxbpahmqjr")
    public suspend fun sourceStorage(`value`: Output<String>) {
        this.sourceStorage = value
    }

    /**
     * @param value The status of the Data flow. Valid values: `Running`, `Stopped`.
     */
    @JvmName("nfmmbnwcbayqevbu")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The maximum transmission bandwidth of data flow, unit: `MB/s`. Valid values: `1200`, `1500`, `600`. **NOTE:** The transmission bandwidth of data flow must be less than the IO bandwidth of the file system.
     */
    @JvmName("erikqbrabymhnboc")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value The Description of the data flow. Restrictions:
     */
    @JvmName("auvvprqyepqxagto")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The dry run.
     */
    @JvmName("awnjnwhtxjadmyol")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The ID of the file system.
     */
    @JvmName("ibslrkejynnaryhx")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The ID of the Fileset.
     */
    @JvmName("athpvmeosrwxrors")
    public suspend fun fsetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsetId = mapped
    }

    /**
     * @param value The security protection type of the source storage. If the source storage must be accessed through security protection, specify the security protection type of the source storage. Value:
     * - `NONE` (default): Indicates that the source storage does not need to be accessed through security protection.
     * - `SSL`: Protects access through SSL certificates.
     */
    @JvmName("erchigsxuvkuefgv")
    public suspend fun sourceSecurityType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSecurityType = mapped
    }

    /**
     * @param value The access path of the source store. Format: `<storage type>://<path>`. Among them:
     * - storage type: currently only OSS is supported.
     * - path: the bucket name of OSS.
     * - Only lowercase letters, numbers, and dashes (-) are supported and must start and end with lowercase letters or numbers.
     */
    @JvmName("pfixthfcobjeiqay")
    public suspend fun sourceStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceStorage = mapped
    }

    /**
     * @param value The status of the Data flow. Valid values: `Running`, `Stopped`.
     */
    @JvmName("hotokcjhwusrsfiv")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The maximum transmission bandwidth of data flow, unit: `MB/s`. Valid values: `1200`, `1500`, `600`. **NOTE:** The transmission bandwidth of data flow must be less than the IO bandwidth of the file system.
     */
    @JvmName("abqqywrdiuyiwbju")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    internal fun build(): DataFlowArgs = DataFlowArgs(
        description = description,
        dryRun = dryRun,
        fileSystemId = fileSystemId,
        fsetId = fsetId,
        sourceSecurityType = sourceSecurityType,
        sourceStorage = sourceStorage,
        status = status,
        throughput = throughput,
    )
}
